#' Indirect regression method for ordinal response
#'
#' @param data data
#' @param W number of ordinal response
#' @param Id id of patient
#' @param Occasion method id
#' @param X coavariate of patient
#' @param Test_result result of test
#' @param True_condition true condition of patient
#' @param init initial guess of eqution
#'
#'@import Matrix
#'@import nleqslv
#'@import BB
#'@import reshape2
#'@import dplyr
#'@import ggplot2
#'@import numDeriv
#'@import VGAM
#'@import haven
#'@import ggalt
#' @return solution of parameter, two figures of ROC,AUC
#' @export
#'
Ordi_ROC<-function(data,W,Id,Occasion,X,Test_result,True_condition,init)
  #  W is the number of test responses, X is vector of covariates
{
  id=data[[Id]]
  occasion=data[[Occasion]]
  sigma<-function(miu)
  {
    miu-miu^2
  }
  Q=length(table(occasion)) #Q is the number of occasions
  N=length(table(id))#N is the number of patients
  all_matrix=expand.grid(w2=1:(W-1),w1=1:(W-1),q2=1:Q,q1=1:Q,i=1:N)
  all_matrix=all_matrix[all_matrix$q1<all_matrix$q2,]
  corr_matrix=expand.grid(w2=1:(W-1),w1=1:(W-1),q2=1:Q,q1=1:Q)
  corr_matrix=corr_matrix[corr_matrix$q1<corr_matrix$q2,]
  qwi_matrix=expand.grid(w=1:(W-1),q=1:Q,i=1:N)
  qw_matrix=expand.grid(w=1:(W-1),q=1:Q)
  X=data[[X]][1:N]#derive the covariate vector x
  d=data[[True_condition]][1:N]#derive the covariate vector x
  Y=array(0,dim=c(N,Q*(W-1)))#setting the indicator function Y of the latent variable
  for(i in 1:N)
    for(q in 1:Q)
      for(w in 1:(W-1))
      {
        Y[i,(q-1)*(W-1)+w]=I(data[data[[Occasion]]==q&data[[Id]]==i,][[Test_result]]<=w)
      }
  f_U<-function(q1,q2,w1,w2)
  {
    I(subset(data,data[[Occasion]]==q1&data[[Id]]==i)[[Test_result]]<=w1)*
      I(subset(data,data[[Occasion]]==q2&data[[Id]]==i)[[Test_result]]<=w2)
  }
  U=matrix(0,N,Q*(Q-1)*(W-1)*(W-1)/2)
  for (i in 1:N)
  {

    U[i,]=mapply(f_U,corr_matrix$q1,corr_matrix$q2,corr_matrix$w1,corr_matrix$w2)
  }
  #using nleqslv package to solve the equation and get the estimated parameter
  solve_my_eq<-function(parameter_vector)
  {
    beta=matrix(0,nrow=Q,ncol=3)
    alpha=matrix(0,nrow=Q,ncol=1)
    C=matrix(0,nrow=Q,ncol=(W-1))
    for(q in 1:Q)
    {
      C[q,]=parameter_vector[((q-1)*(W+3)+1):((q-1)*(W+3)+W-1)]
      beta[q,]=parameter_vector[((q-1)*(W+3)+W):((q-1)*(W+3)+W+2)]
      alpha[q,]=parameter_vector[(q-1)*(W+3)+W+3]
    }
    aita=parameter_vector[Q*(W+3)+1]
    miu<-function(i,q,w)#derive expectation of Y
    {
      pnorm((C[q,w]-(beta[q,1]*X[i]+beta[q,2]*d[i]+beta[q,3]*d[i]*X[i]))/exp(alpha[q,1]*d[i]))
    }
    miu_func<-function(my_parameter1)
    {
      beta_=matrix(0,nrow=Q,ncol=3)
      alpha_=matrix(0,nrow=Q,ncol=1)
      C_=matrix(0,nrow=Q,ncol=(W-1))
      for(q in 1:Q)
      {
        C_[q,]=my_parameter1[((q-1)*(W+3)+1):((q-1)*(W+3)+W-1)]
        beta_[q,]=my_parameter1[((q-1)*(W+3)+W):((q-1)*(W+3)+W+2)]
        alpha_[q,]=my_parameter1[(q-1)*(W+3)+W+3]
      }
      func<-function(q,w)
      {
        pnorm((C_[q,w]-(beta_[q,1]*X[i]+beta_[q,2]*d[i]+beta_[q,3]*d[i]*X[i]))/exp(alpha_[q,1]*d[i]))
      }
      mapply(func,qw_matrix$q,qw_matrix$w)
    }
    niu_func<-function(my_parameter2)
    {
      func=function(q1,q2,w1,w2)
      {
        I(q1!=q2)*pbinorm(qnorm(miu(i,q1,w1)),qnorm(miu(i,q2,w2)),(1-exp(my_parameter2))/(1+exp(my_parameter2)))+
          I(q1==q2)*miu(i,q1,min(w1,w2))
      }
      mapply(func,corr_matrix$q1,corr_matrix$q2,corr_matrix$w1,corr_matrix$w2)
    }
    result=rep(0,Q*(W+3)+1)
    for (i in 1:N)
    {
      niu=niu_func(aita)
      S1=t(jacobian(miu_func,parameter_vector[-(Q*(W+3)+1)]))%*%as.matrix(Y[i,]-miu_func(parameter_vector[-(Q*(W+3)+1)]))
      S2=t(jacobian(niu_func,aita))%*%as.matrix(U[i,]-niu)
      result=result+c(S1,S2)
    }
    #print(c(parameter_vector,result))
    return(result)
  }
  solution=dfsane(init
                  ,solve_my_eq)
  parameter=solution[["par"]]
  beta=matrix(0,nrow=Q,ncol=3)
  alpha=matrix(0,nrow=Q,ncol=1)
  for(q in 1:Q)
  {
    beta[q,]=parameter[((q-1)*(W+3)+W):((q-1)*(W+3)+W+2)]
    alpha[q,]=parameter[(q-1)*(W+3)+W+3]
  }
  a_qx<-function(q,x)
  {
    (beta[q,2]+beta[q,3]*x)/exp(alpha[q,1])
  }
  b_qx<-function(q,x)
  {
    exp(-alpha[q,1])
  }
  Ordi_ROC_curve<-function(q,x)#derive the ROC curve
  {
    Ordi_ROC_func<-function(p)
    {
      1-pnorm(b_qx(q,x)*qnorm(1-p)-a_qx(q,x))
    }
    seq=seq(0,1,by=0.01)
    outcome=data.frame("x"=seq,"y"=sapply(seq,Ordi_ROC_func))
    return(sapply(seq,Ordi_ROC_func))
  }
  outcome_0=seq(0,1,by=0.01)
  outcome_1=seq(0,1,by=0.01)
  Ordi_AUC<-function(q,x)
  {
    pnorm(a_qx(q,x)/(1+b_qx(q,x))^0.5)
  }
  AUC=matrix(0,2,Q)
  for(q in 1:Q)
  {
    outcome_0=cbind(outcome_0,Ordi_ROC_curve(q,0))
    outcome_1=cbind(outcome_1,Ordi_ROC_curve(q,1))
    AUC[1,q]=Ordi_AUC(q,0)
    AUC[2,q]=Ordi_AUC(q,1)
  }
  outcome_0=as.data.frame(outcome_0)
  colnames(outcome_0)=c("x",letters[1:Q])
  outcome_0=melt(outcome_0,id.vars = "x")
  outcome_1=as.data.frame(outcome_1)
  colnames(outcome_1)=c("x",letters[1:Q])
  outcome_1=melt(outcome_1,id.vars="x")
  fig_0=ggplot(outcome_0,aes(x=x,y=value,color=variable))+geom_point()
  fig_1=ggplot(outcome_1,aes(x=x,y=value,color=variable))+geom_point()
  return(list(parameter,fig_0,fig_1,
              AUC))
}

