#' Regression method for multi-reader method
#'
#' @param data data
#' @param data_reader covariate of reader
#' @param reader reader id
#' @param method method id
#' @param true_condition true_condition of patient
#' @param id id of patient
#' @param score test result of patient
#'
#'@import nleqslv
#'@import reshape2
#'@import dplyr
#'@import ggplot2
#'@import numDeriv
#'@import haven
#' @return parameter,AUC mean,AUC sd
#' @export
#'
Margi_ROC<-function(data,data_reader,reader,method,true_condition,id,score)
{
  I=length(table(data[[method]]))
  J=length(table(data[[reader]]))
  data_subset=data[data[[reader]]==1&data[[method]]==1,]
  N=nrow(data_subset)
  n_1=nrow(data_subset[data_subset[[true_condition]]==1,])
  n_0=N-n_1
  n_beta_2=ncol(data_reader)-1
  fai=array(0,dim=c(I,J,n_1,n_0))
  for(i in 1:I)
    for(j in 1:J)
      for(k in (n_0+1):N)
        for(s in 1:n_0)
        {
          fai[i,j,(k-n_0),s]=as.numeric(I(data[data[[reader]]==j&data[[id]]==k&data[[method]]==i,][[score]]>
                                            data[data[[reader]]==j&data[[id]]==s&data[[method]]==i,][[score]]))
        }
  base_vector<-function(i){
    vec=rep(0,I)
    vec[i]=1
    vec
  }
  W<-function(i,j)
  {
    c(base_vector(i),t(as.numeric(data_reader[j,-1])))
  }
  solve_my_eq<-function(beta)
  {
    S <- rep(0, I+n_beta_2)
    for(i in 1:I)
      for(j in 1:J)
      {
        fai_ijks <- sum(fai[i, j, 1:n_1, 1:n_0])
        beta_W <- t(beta) %*% W(i, j)
        p_beta_W <- pnorm(beta_W)
        S <- S + c((fai_ijks - n_1*n_0*p_beta_W) * dnorm(beta_W) / p_beta_W / (1 - p_beta_W) )* W(i, j)
      }
    return(S)
  }
  solution=nleqslv(rep(0,(I+n_beta_2)),fn=solve_my_eq)
  parameter=solution$x
  #parameter=c(8.800394e-02,4.911494e-01, 2.075196e-04,1.802933e-03)
  A=array(0,dim=c(I,J))
  for(i in 1:I)
    for(j in 1:J)
    {
      A[i,j]=pnorm(t(parameter[1:I])%*%base_vector(i)+t(parameter[(I+1):(I+n_beta_2)])%*%as.numeric(data_reader[j,-1]))
    }
  AUC_mean=apply(A,1,mean)
  temp<-function(beta)
  {
    (sum(fai[i,j,1:n_1,1:n_0])-n_1*n_0*pnorm(t(beta)%*%W(i,j)))*dnorm(t(beta)%*%W(i,j))/
      pnorm(t(beta)%*%W(i,j))/(1-pnorm(t(beta)%*%W(i,j)))
  }
  C=matrix(0,(I+n_beta_2),(I+n_beta_2))
  for(i in 1:I)
    for(j in 1:J)
    {
      C=C+W(i,j)%*%jacobian(temp,parameter)
    }
  B=matrix(0,(I+n_beta_2),(I+n_beta_2))
  for(i in 1:I)
    for(j in 1:J)
      for(i_hat in 1:I)
        for(j_hat in 1:J)
        {
          for(s in 1:n_0)
          {
            u1=c((sum(fai[i,j,1:n_1,s])-n_1*pnorm(t(parameter)%*%W(i,j)))*dnorm(t(parameter)%*%W(i,j))/
                   pnorm(t(parameter)%*%W(i,j))/(1-pnorm(t(parameter)%*%W(i,j))))*W(i,j)
            u2=c((sum(fai[i_hat,j_hat,1:n_1,s])-n_1*pnorm(t(parameter)%*%W(i_hat,j_hat)))*dnorm(t(parameter)%*%W(i_hat,j_hat))/
                   pnorm(t(parameter)%*%W(i_hat,j_hat))/(1-pnorm(t(parameter)%*%W(i_hat,j_hat))))*W(i_hat,j_hat)
            B=B+u1%*%t(u2)
          }
          for(k in 1:n_1)
          {
            u1=c((sum(fai[i,j,k,1:n_0])-n_0*pnorm(t(parameter)%*%W(i,j)))*dnorm(t(parameter)%*%W(i,j))/
                   pnorm(t(parameter)%*%W(i,j))/(1-pnorm(t(parameter)%*%W(i,j))))*W(i,j)
            u2=c((sum(fai[i_hat,j_hat,k,1:n_0])-n_0*pnorm(t(parameter)%*%W(i_hat,j_hat)))*dnorm(t(parameter)%*%W(i_hat,j_hat))/
                   pnorm(t(parameter)%*%W(i_hat,j_hat))/(1-pnorm(t(parameter)%*%W(i_hat,j_hat))))*W(i_hat,j_hat)
            B=B+u1%*%t(u2)
          }

          u1=c(t(as.vector(fai[i_hat,j_hat,1:n_1,1:n_0])-as.vector(pnorm(t(parameter)%*%W(i_hat,j_hat))))%*%
                 (as.vector(fai[i,j,1:n_1,1:n_0])-as.vector(pnorm(t(parameter)%*%W(i,j)))*dnorm(t(parameter)%*%W(i,j)))/
                 pnorm(t(parameter)%*%W(i,j))/(1-pnorm(t(parameter)%*%W(i,j))))*W(i,j)
          u2=c(dnorm(t(parameter)%*%W(i_hat,j_hat))/pnorm(t(parameter)%*%W(i_hat,j_hat))/
                 (1-pnorm(t(parameter)%*%W(i_hat,j_hat))))*W(i_hat,j_hat)
          B=B-u1%*%t(u2)

        }

  se=array(0,c(I,J))
  for(i in 1:I)
    for(j in 1:J)
    {
      se[i,j]=sqrt(t(c(dnorm(t(parameter)%*%W(i,j)))*W(i,j))%*%solve(C)%*%B%*%t(solve(C))%*%(c(dnorm(t(parameter)%*%W(i,j)))*W(i,j)))
    }
  sandwich=solve(C)%*%B%*%t(solve(C))
  #mean(se[1,])
  #mean(se[2,])
  AUC_sd=apply(se,1,mean)
  return(list(parameter,AUC_mean,AUC_sd))
}
