#' Applied bootstrap on direct regression method for continuous response
#'
#' @param data data
#' @param ID id of patient
#' @param true_condition true_condition of patient,binary
#' @param occasion method,1,2,...,Q
#' @param test_result result of test
#' @param X covariate of patient
#' @param func_H link function
#' @param initial_guess the initial guess of the equation
#' @param n_T number of cutting point of empirical function
#' @param B number of bootstrap
#'
#'@import nleqslv
#'@import BB
#'@import reshape2
#'@import dplyr
#'@import ggplot2
#'@import haven
#' @return parameter mean,parameter var,AUC mean,AUC var
#' @export
#'
Cont_boots<-function(data,ID,true_condition,occasion,test_result,X,func_H,initial_guess,n_T,B)
{
multi_str<-function(str,Q,n)
{
  for (i in 2:Q)
    str=c(str,str+(i-1)*n)
  return (str)
}
copy_str<-function(str,n)
{
  for (i in 2:n)
    str=c(str,str)
  str
}
Q=length(table(data[[occasion]]))#Q is the number of occasions
N=length(data[[ID]])/Q
data_0=data[data[[true_condition]]==0,]
data_0[[ID]]=seq(nrow(data_0)/Q)
data_1=data[data[[true_condition]]==1,]
data_1[[ID]]=seq(nrow(data_1)/Q)+nrow(data_0)/Q
para_B=matrix(0,B,4*Q)
AUC_B=matrix(0,B,2*Q)
for (b in 1:B)
{ sample_0=data_0[
  multi_str(sample(x=unique(data_0[[ID]]),size=length(unique(data_0[[ID]])),replace = TRUE),Q,length(unique(data_0[[ID]]))),]
  sample_1=data_1[
  multi_str((sample(x=unique(data_1[[ID]]),size=length(unique(data_1[[ID]])),replace = TRUE)-length(unique(data_0[[ID]]))),Q,length(unique(data_1[[ID]]))),]
  sample=as.data.frame(rbind(sample_0,sample_1))
  sample[[ID]]=c(copy_str(seq(1:length(unique(data_0[[ID]]))),Q),copy_str((seq(1:length(unique(data_1[[ID]])))+length(unique(data_0[[ID]]))),Q))
  outcome=Cont_ROC(sample,ID,true_condition,occasion,test_result,X,func_H,initial_guess,n_T)
  para_B[b,]=outcome[[1]]
  AUC_B[b,]=outcome[[4]]
}
print(AUC_B)
AUC_mean=apply(AUC_B,2,mean)
para_mean=apply(para_B,2,mean)
AUC_var=t(AUC_B-AUC_mean)%*%(AUC_B-AUC_mean)/(B-1)
para_var=t(para_B-para_mean)%*%(para_B-para_mean)/(B-1)
return(list(para_mean,para_var,AUC_mean,AUC_var))
}
