% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odpROC.R
\name{odpROC}
\alias{odpROC}
\title{Direct Parametric Regression Model for Ordinal-Scale ROC Curves}
\usage{
odpROC(
  vars,
  eta_vars,
  data,
  data_d,
  newdata_d,
  response,
  link = "probit",
  base = c("probit"),
  Intercept = TRUE,
  eta = "probit",
  link_ordinal = "probit",
  level = 0.95,
  n_boot = 1000
)
}
\arguments{
\item{vars}{a vector of characters representing the covariates in the model.}

\item{eta_vars}{a vector of characters representing the covariates interacting
with functions of p in the model.}

\item{data}{a data frame consisting of data from subjects without condition.}

\item{data_d}{a data frame consisting of data from subjects with condition.}

\item{newdata_d}{a data frame for generating ROC curve.}

\item{response}{a character representing the name of the column in both data
and data_d that represents the test results of subjects.}

\item{link}{link function in direct regression model. "probit", "logit" or "cauchit".
Default "probit".}

\item{base}{base functions in direct regression model. A vector consisting of
one or more of "probit", "logit" and "cauchit".}

\item{Intercept}{indicates whether the model contains a constant term. Default TRUE.}

\item{eta}{function interacting with eta_vars. "probit", "logit" or "cauchit".
Default "probit".}

\item{link_ordinal}{link function of the ordinal regression model of the survival
function of subjects' latent variable without condition. "probit",
"logit" or "cauchit". Default "probit".}

\item{level}{the confidence level. Default 0.95.}

\item{n_boot}{the number of bootstrap samples to draw. Default 1000.}
}
\value{
a list of the parameters of the model and the AUC of the corresponding ROC curve.
}
\description{
you can use this function to fit an direct parametric regression
model for ordinal-scale ROC curves. This function will print and return
the parameters of the model and the AUC of the corresponding ROC curve,
and will make an image of the ROC curve and its confidence band.
}
\examples{
\donttest{
data("data_ordinal")
data <- data_ordinal[data_ordinal[["d"]] == 0, c("t", "x1", "x2")]
data_d <- data_ordinal[data_ordinal[["d"]] == 1, c("t", "x1", "x2")]
odpROC(vars = c("x1", "x2"),
       eta_vars = c(),
       data = data,
       data_d = data_d,
       newdata_d = data.frame(x1 = c(0), x2 = c(0)),
       response = "t")
}

}
