% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oiROC.R
\name{oiROC}
\alias{oiROC}
\title{Indirect Regression Model for Ordinal-Scale ROC Curves}
\usage{
oiROC(
  location,
  scale,
  data,
  newdata,
  group,
  link = "probit",
  level = 0.95,
  n_boot = 1000
)
}
\arguments{
\item{location}{a two-sided formula with the response variable on the LHS and
the predictor for the location on the RHS.}

\item{scale}{a one-sided formula with the predictor for the scale on the RHS.}

\item{data}{a data frame in which to evaluate the indirect regression model.}

\item{newdata}{a data frame for generating ROC curve.}

\item{group}{a character representing the name of the column in data that
represents the true condition of subjects.}

\item{link}{link function, i.e., the type of location-scale distribution assumed
for the latent distribution. "probit"(default), "logit" or "cauchit".}

\item{level}{the confidence level. Default 0.95.}

\item{n_boot}{the number of bootstrap samples to draw. Default 1000.}
}
\value{
a list of the parameters of the model and the AUC of the corresponding ROC curve.
}
\description{
you can use this function to fit an indirect regression model for
ordinal-scale ROC curves. This function will print and return the parameters
of the model and the AUC of the corresponding ROC curve, and will make an
image of the ROC curve and its confidence band.
}
\examples{
\donttest{
data("data_ordinal")
oiROC(location = t ~ d * (x1 + x2),
      scale = ~ d * (x1 + x2),
      data = data_ordinal,
      newdata = data.frame(x1 = c(0), x2 = c(0)),
      group = "d")
}

}
