% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciROC.R
\name{ciROC}
\alias{ciROC}
\title{Indirect Regression Model for Continuous-Scale ROC Curves}
\usage{
ciROC(location, scale, data, newdata, group, level = 0.95, n_boot = 1000)
}
\arguments{
\item{location}{a two-sided formula with the response variable on the LHS and
the predictor for the mean on the RHS.}

\item{scale}{a one-sided formula with the predictor for the standard deviation on the RHS.}

\item{data}{a data frame in which to evaluate the indirect regression model.}

\item{newdata}{a data frame for generating ROC curve.}

\item{group}{a character representing the name of the column in data that
represents the true condition of subjects.}

\item{level}{the confidence level. Default 0.95.}

\item{n_boot}{the number of bootstrap samples to draw. Default 1000.}
}
\value{
a list of the parameters of the model and the AUC of the corresponding ROC curve.
}
\description{
you can use this function to fit an indirect regression model for
continuous-scale ROC curves. This function will print and return the parameters
of the model and the AUC of the corresponding ROC curve, and will make an
image of the ROC curve and its confidence band.
}
\examples{
\donttest{
data("data_continous")
ciROC(location = t ~ d * (x1 + x2),
      scale = ~ d * (x1 + x2),
      data = data_continous,
      newdata = data.frame(x1 = c(0), x2 = c(0)),
      group="d")
}

}
