% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdspROC2.R
\name{cdspROC2}
\alias{cdspROC2}
\title{Direct Semi-Parametric Regression Model for Continuous-Scale ROC Curves}
\usage{
cdspROC2(
  vars,
  data,
  data_d,
  newdata_d,
  response,
  link = "probit",
  level = 0.95,
  n_boot = 1000
)
}
\arguments{
\item{vars}{a vector of characters representing the covariates in the model.}

\item{data}{a data frame consisting of data from subjects without condition.}

\item{data_d}{a data frame consisting of data from subjects with condition.}

\item{newdata_d}{a data frame for generating ROC curve.}

\item{response}{a character representing the name of the column in both data
and data_d that represents the test results of subjects.}

\item{link}{link function in direct regression model. "probit", "logit" or "cauchit".
Default "probit".}

\item{level}{the confidence level. Default 0.95.}

\item{n_boot}{the number of bootstrap samples to draw. Default 1000.}
}
\value{
a list of the parameters of the model and the AUC of the corresponding ROC curve.
}
\description{
you can use this function to fit an direct semi-parametric regression
model for continuous-scale ROC curves based on placement values. This
function will print and return the parameters of the model and the AUC of
the corresponding ROC curve, and will make an image of the ROC curve and
its confidence band.
}
\examples{
\donttest{
data("data_continous")
data <- data_continous[data_continous[["d"]] == 0, c("t", "x1", "x2")]
data_d <- data_continous[data_continous[["d"]] == 1, c("t", "x1", "x2")]
cdspROC2(vars = c("x1", "x2"),
         data = data,
         data_d = data_d,
         newdata_d = data.frame(x1 = c(0), x2 = c(0)),
         response = "t")
}

}
