% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdpROC.R
\name{cdpROC}
\alias{cdpROC}
\title{Direct Parametric Regression Model for Continuous-Scale ROC Curves}
\usage{
cdpROC(
  vars,
  eta_vars,
  data,
  data_d,
  newdata_d,
  response,
  link = "probit",
  base = c("probit"),
  Intercept = TRUE,
  eta = "probit",
  p_lower = 0,
  p_upper = 1,
  n_p = 50,
  level = 0.95,
  n_boot = 1000
)
}
\arguments{
\item{vars}{a vector of characters representing the covariates in the model.}

\item{eta_vars}{a vector of characters representing the covariates interacting
with functions of p in the model.}

\item{data}{a data frame consisting of data from subjects without condition.}

\item{data_d}{a data frame consisting of data from subjects with condition.}

\item{newdata_d}{a data frame for generating ROC curve.}

\item{response}{a character representing the name of the column in both data
and data_d that represents the test results of subjects.}

\item{link}{link function in direct regression model. "probit", "logit" or "cauchit".
Default "probit".}

\item{base}{base functions in direct regression model. A vector consisting of
one or more of "probit", "logit" and "cauchit".}

\item{Intercept}{indicates whether the model contains a constant term. Default TRUE.}

\item{eta}{function interacting with eta_vars. "probit", "logit" or "cauchit".
Default "probit".}

\item{p_lower}{the lower bound of fprs that users are interested in. Default 0.0.}

\item{p_upper}{the upper bound of fprs that users are interested in. Default 1.0.}

\item{n_p}{the number of fprs for estimating the regression model. Default 50.}

\item{level}{the confidence level. Default 0.95.}

\item{n_boot}{the number of bootstrap samples to draw. Default 1000.}
}
\value{
a list of the parameters of the model and the AUC of the corresponding ROC curve.
}
\description{
you can use this function to fit an direct parametric regression
model for continuous-scale ROC curves. This function will print and return
the parameters of the model and the AUC of the corresponding ROC curve,
and will make an image of the ROC curve and its confidence band.
}
\examples{
\donttest{
data("data_continous")
data <- data_continous[data_continous[["d"]] == 0, c("t", "x1", "x2")]
data_d <- data_continous[data_continous[["d"]] == 1, c("t", "x1", "x2")]
cdpROC(vars = c("x1", "x2"),
       eta_vars = c(),
       data = data,
       data_d = data_d,
       newdata_d = data.frame(x1 = c(0), x2 = c(0)),
       response = "t")
}

}
