% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4.1.2.R
\name{roc.ppvnpv}
\alias{roc.ppvnpv}
\title{Compute PPV and NPV for binary scale tests
prevalence rate=x/n}
\usage{
roc.ppvnpv(data, alpha, x, n)
}
\arguments{
\item{data}{2*2 table of test results of diseased and nondiseased subjects}

\item{alpha}{significance level}

\item{x}{the number of diseased subjects in n subjects}

\item{n}{the number of subjects evaluated in a random sample from the relevant population}
}
\value{
1) Estimated PPV and NPV in the study population(where the original data comes from)
and their confidence intervals(based on Wald's interval)
2) Estimated PPV and NPV in a relevant population(with a different prevalence rate as the study population)
and three different confidence intervals, the first is based on logit transformation,
the second is based on Delta method, and the third is based on objective Bayesian method.
#example
#data<-matrix(c(56,6,23,78),nrow=2,byrow=TRUE)
#roc.ppvnpv(data,0.05,124,632)
}
\description{
Compute PPV and NPV for binary scale tests
prevalence rate=x/n
}
