# 14_utils.R

# 生成模拟数据的函数
generate_simulated_data_1 <- function(K, theta_00, theta_01, theta_10, theta_11) {
  # 生成二元变量 T, B, A
  T <- sample(c(0, 1), K, replace = TRUE)
  B <- sample(c(0, 1), K, replace = TRUE)
  A <- sample(c(0, 1), K, replace = TRUE)
  
  # 生成结果变量 Y
  Y <- numeric(K)
  for (i in 1:K) {
    if (A[i] == 0 && B[i] == 0) {
      Y[i] <- rnorm(1, mean = theta_00, sd = 1)
    } else if (A[i] == 0 && B[i] == 1) {
      Y[i] <- rnorm(1, mean = theta_01, sd = 1)
    } else if (A[i] == 1 && B[i] == 0) {
      Y[i] <- rnorm(1, mean = theta_10, sd = 1)
    } else if (A[i] == 1 && B[i] == 1) {
      Y[i] <- rnorm(1, mean = theta_11, sd = 1)
    }
  }
  
  # 返回生成的数据
  return(data.frame(T = T, B = B, A = A, Y = Y))
}

# 估计参数的函数
estimate_parameters_1 <- function(data) {
  K <- nrow(data)
  
  T <- data[, 1]
  B <- data[, 2]
  A <- data[, 3]
  
  theta_00 <- mean(data[A == 0 & B == 0, 4])
  theta_01 <- mean(data[A == 0 & B == 1, 4])
  theta_10 <- mean(data[A == 1 & B == 0, 4])
  theta_11 <- mean(data[A == 1 & B == 1, 4])
  
  theta_0_0 <- mean(data[A == 0 & T == 0, 4])
  theta_0_1 <- mean(data[A == 0 & T == 1, 4])
  theta_1_0 <- mean(data[A == 1 & T == 0, 4])
  theta_1_1 <- mean(data[A == 1 & T == 1, 4])
  
  eta_0 <- theta_01 - theta_00
  eta_1 <- theta_11 - theta_10
  
  p_1 <- mean(B[T == 1])
  p_0 <- mean(B[T == 0])
  f <- p_1 - p_0
  eta_star_0 <- f * eta_0
  eta_star_1 <- f * eta_1
  
  delta_0 <- theta_10 - theta_00
  delta_1 <- theta_11 - theta_01
  
  Delta <- delta_1 - delta_0
  
  delta_dot_0 <- delta_0 + p_0 * (delta_1 - delta_0)
  delta_dot_1 <- delta_0 + p_1 * (delta_1 - delta_0)
  
  Delta_star <- f * Delta
  
  return(list(
    K = K,
    theta_00 = theta_00, theta_01 = theta_01, theta_10 = theta_10, theta_11 = theta_11,
    theta_0_0 = theta_0_0, theta_0_1 = theta_0_1, theta_1_0 = theta_1_0, theta_1_1 = theta_1_1,
    eta_0 = eta_0, eta_1 = eta_1,
    eta_star_0 = eta_star_0, eta_star_1 = eta_star_1,
    delta_0 = delta_0, delta_1 = delta_1,
    Delta = Delta,
    delta_dot_0 = delta_dot_0, delta_dot_1 = delta_dot_1,
    Delta_star = Delta_star
  ))
}























# 14_utils.R

# 生成模拟数据的函数
generate_simulated_data_2 <- function(K, theta_00, theta_01, theta_10, theta_11) {
  S <- sample(c(0, 1), K, replace = TRUE)
  T <- sample(c(0, 1), K, replace = TRUE)
  B <- sample(c(0, 1), K, replace = TRUE)
  
  A <- numeric(K)
  for (i in 1:K) {
    if (S[i] == T[i]) {
      A[i] <- S[i]
    } else {
      A[i] <- sample(c(0, 1), 1)
    }
  }
  
  Y <- numeric(K)
  for (i in 1:K) {
    if (A[i] == 0 && B[i] == 0) {
      Y[i] <- rnorm(1, mean = theta_00, sd = 1)
    } else if (A[i] == 0 && B[i] == 1) {
      Y[i] <- rnorm(1, mean = theta_01, sd = 1)
    } else if (A[i] == 1 && B[i] == 0) {
      Y[i] <- rnorm(1, mean = theta_10, sd = 1);
    } else if (A[i] == 1 && B[i] == 1) {
      Y[i] <- rnorm(1, mean = theta_11, sd = 1);
    }
  }
  
  return(data.frame(S = S, T = T, B = B, A = A, Y = Y))
}

# 估计参数的函数
estimate_parameters_2 <- function(data) {
  K <- nrow(data)
  
  S <- data[, 1]
  T <- data[, 2]
  B <- data[, 3]
  A <- data[, 4]
  
  theta_00 <- mean(data[A == 0 & B == 0, 5])
  theta_01 <- mean(data[A == 0 & B == 1, 5])
  theta_10 <- mean(data[A == 1 & B == 0, 5])
  theta_11 <- mean(data[A == 1 & B == 1, 5])
  
  theta_0_00 <- mean(data[A == 0 & S == 0 & T == 0, 5])
  theta_0_01 <- mean(data[A == 0 & S == 0 & T == 1, 5])
  theta_0_10 <- mean(data[A == 0 & S == 1 & T == 0, 5])
  theta_0_11 <- mean(data[A == 0 & S == 1 & T == 1, 5])
  theta_1_00 <- mean(data[A == 1 & S == 0 & T == 0, 5])
  theta_1_01 <- mean(data[A == 1 & S == 0 & T == 1, 5])
  theta_1_10 <- mean(data[A == 1 & S == 1 & T == 0, 5])
  theta_1_11 <- mean(data[A == 1 & S == 1 & T == 1, 5])
  
  eta_0 <- theta_01 - theta_00
  eta_1 <- theta_11 - theta_10
  
  p_00 <- mean(B[S == 0 & T == 0])
  p_01 <- mean(B[S == 0 & T == 1])
  p_10 <- mean(B[S == 1 & T == 0])
  p_11 <- mean(B[S == 1 & T == 1])
  f <- p_01 - p_10
  eta_star_0 <- f * eta_0
  eta_star_1 <- f * eta_1
  
  delta_0 <- theta_10 - theta_00
  delta_1 <- theta_11 - theta_01
  
  Delta <- delta_1 - delta_0
  
  delta_dot_00 <- delta_0 + p_00 * (delta_1 - delta_0)
  delta_dot_01 <- delta_0 + p_01 * (delta_1 - delta_0)
  delta_dot_10 <- delta_0 + p_10 * (delta_1 - delta_0)
  delta_dot_11 <- delta_0 + p_11 * (delta_1 - delta_0)
  
  Delta_DP <- delta_dot_01 - delta_dot_10
  
  return(list(
    K = K,
    theta_00 = theta_00, theta_01 = theta_01, theta_10 = theta_10, theta_11 = theta_11,
    theta_0_00 = theta_0_00, theta_0_01 = theta_0_01, theta_0_10 = theta_0_10, theta_0_11 = theta_0_11,
    theta_1_00 = theta_1_00, theta_1_01 = theta_1_01, theta_1_10 = theta_1_10, theta_1_11 = theta_1_11,
    eta_0 = eta_0, eta_1 = eta_1,
    eta_star_0 = eta_star_0, eta_star_1 = eta_star_1,
    delta_0 = delta_0, delta_1 = delta_1,
    Delta = Delta,
    delta_dot_00 = delta_dot_00, delta_dot_01 = delta_dot_01, delta_dot_10 = delta_dot_10, delta_dot_11 = delta_dot_11,
    Delta_DP = Delta_DP
  ))
}









# 14.7.1 Test Strategy Design all treatment 0 in control 
# 定义函数来生成模拟数据
generate_simulated_data_3 <- function(K, theta_00, theta_01, theta_10, theta_11, missing_rate) {
  # 生成二元变量T, B
  T <- sample(c(0, 1, NA), K, replace = TRUE, prob = c(0.5, 0.5, missing_rate))
  B <- sample(c(0, 1), K, replace = TRUE)
  
  # 生成治疗变量A
  A <- numeric(K)
  for (i in 1:K) {
    if (is.na(T[i])) {
      A[i] <- 0  # T是缺失值时，分配治疗A=0
    } else {
      A[i] <- T[i]  # T = 0时分配治疗A=0，T = 1时分配治疗A=1
    }
  }
  
  # 生成结局变量Y，确保给定B，Y的分布与T无关
  Y <- numeric(K)
  for (i in 1:K) {
    if (A[i] == 0 && B[i] == 0) {
      Y[i] <- rnorm(1, mean = theta_00, sd = 1)
    } else if (A[i] == 0 && B[i] == 1) {
      Y[i] <- rnorm(1, mean = theta_01, sd = 1)
    } else if (A[i] == 1 && B[i] == 0) {
      Y[i] <- rnorm(1, mean = theta_10, sd = 1)
    } else if (A[i] == 1 && B[i] == 1) {
      Y[i] <- rnorm(1, mean = theta_11, sd = 1)
    }
  }
  
  # 返回生成的数据
  return(data.frame(T = T, B = B, A = A, Y = Y))
}

# 定义函数来处理数据输入并计算∆_{TS.UC}
calculate_delta_TS_UC <- function(data) {
  # 计算样本数K
  K <- nrow(data)
  
  # 计算二元变量T, B, A的频率
  T <- data[, 1]
  B <- data[, 2]
  A <- data[, 3]
  Y <- data[, 4]
  
  # 计算T不是缺失值的组的Y的均值
  mean_Y_not_missing <- mean(Y[!is.na(T)])
  
  # 计算T是缺失值的组的Y的均值
  mean_Y_missing <- mean(Y[is.na(T)])
  
  # 计算∆_{TS.UC}
  Delta_TS_UC <- mean_Y_not_missing - mean_Y_missing
  
  # 返回结果
  return(list(Delta_TS_UC = Delta_TS_UC))
}












# 14.7.1 Test Strategy Design random assignment in control
# 定义函数来生成模拟数据
generate_simulated_data_4 <- function(K, theta_00, theta_01, theta_10, theta_11, missing_rate, gamma) {
  # 生成二元变量T, B
  T <- sample(c(0, 1, NA), K, replace = TRUE, prob = c(0.5, 0.5, missing_rate))
  B <- sample(c(0, 1), K, replace = TRUE)
  
  # 生成治疗变量A
  A <- numeric(K)
  for (i in 1:K) {
    if (is.na(T[i])) {
      A[i] <- sample(c(0, 1), 1, prob = c(gamma, 1 - gamma))  # 对照组中的患者以概率γ分配到0，(1−γ)分配到治疗1
    } else {
      A[i] <- T[i]  # T = 0时分配治疗A=0，T = 1时分配治疗A=1
    }
  }
  
  # 生成结局变量Y，确保给定B，Y的分布与T无关
  Y <- numeric(K)
  for (i in 1:K) {
    if (A[i] == 0 && B[i] == 0) {
      Y[i] <- rnorm(1, mean = theta_00, sd = 1)
    } else if (A[i] == 0 && B[i] == 1) {
      Y[i] <- rnorm(1, mean = theta_01, sd = 1)
    } else if (A[i] == 1 && B[i] == 0) {
      Y[i] <- rnorm(1, mean = theta_10, sd = 1)
    } else if (A[i] == 1 && B[i] == 1) {
      Y[i] <- rnorm(1, mean = theta_11, sd = 1)
    }
  }
  
  # 返回生成的数据
  return(data.frame(T = T, B = B, A = A, Y = Y))
}

# 定义函数来处理数据输入并计算∆_{TS.RC}
calculate_delta_TS_RC <- function(data) {
  # 计算样本数K
  K <- nrow(data)
  
  # 计算二元变量T, B, A的频率
  T <- data[, 1]
  B <- data[, 2]
  A <- data[, 3]
  Y <- data[, 4]
  
  # 计算T不是缺失值的组的Y的均值
  mean_Y_not_missing <- mean(Y[!is.na(T)])
  
  # 计算T是缺失值的组的Y的均值
  mean_Y_missing <- mean(Y[is.na(T)])
  
  # 计算∆_{TS.RC}
  Delta_TS_RC <- mean_Y_not_missing - mean_Y_missing
  
  # 返回结果
  return(list(Delta_TS_RC = Delta_TS_RC))
}





















#14.7.2 Comparative Test Strategy Design
# 定义函数来生成模拟数据
generate_simulated_data_5 <- function(K, theta_00, theta_01, theta_10, theta_11) {
  # 生成二元变量S, T, B, Z
  S <- sample(c(0, 1), K, replace = TRUE)
  T <- sample(c(0, 1), K, replace = TRUE)
  B <- sample(c(0, 1), K, replace = TRUE)
  Z <- sample(c(0, 1), K, replace = TRUE)
  
  # 生成治疗变量A
  A <- numeric(K)
  for (i in 1:K) {
    if (Z[i] == 0) {
      A[i] <- T[i]  # Z = 0时，使用测试T的结果分配治疗
    } else {
      A[i] <- S[i]  # Z = 1时，使用测试S的结果分配治疗
    }
  }
  
  # 生成结局变量Y，确保给定B，Y的分布与(S, T)无关
  Y <- numeric(K)
  for (i in 1:K) {
    if (A[i] == 0 && B[i] == 0) {
      Y[i] <- rnorm(1, mean = theta_00, sd = 1)
    } else if (A[i] == 0 && B[i] == 1) {
      Y[i] <- rnorm(1, mean = theta_01, sd = 1)
    } else if (A[i] == 1 && B[i] == 0) {
      Y[i] <- rnorm(1, mean = theta_10, sd = 1)
    } else if (A[i] == 1 && B[i] == 1) {
      Y[i] <- rnorm(1, mean = theta_11, sd = 1)
    }
  }
  
  # 返回生成的数据
  return(data.frame(S = S, T = T, B = B, Z = Z, A = A, Y = Y))
}

# 定义函数来处理数据输入并计算∆_{CTS}
calculate_delta_CTS <- function(data) {
  # 计算样本数K
  K <- nrow(data)
  
  # 计算二元变量S, T, B, Z, A的频率
  S <- data[, 1]
  T <- data[, 2]
  B <- data[, 3]
  Z <- data[, 4]
  A <- data[, 5]
  Y <- data[, 6]
  
  # 计算Z = 0的组的Y的均值
  mean_Y_Z0 <- mean(Y[Z == 0])
  
  # 计算Z = 1的组的Y的均值
  mean_Y_Z1 <- mean(Y[Z == 1])
  
  # 计算∆_{CTS}
  Delta_CTS <- mean_Y_Z0 - mean_Y_Z1
  
  # 返回结果
  return(list(Delta_CTS = Delta_CTS))
}
