# 14_ui_modules.R

# 第一个子页面的 UI 设计
estimate_ui_1 <- tabPanel(
  title = "Explanatory vs. Pragmatic Trials of Tests",
  fluidPage(
    titlePanel("Explanatory vs. Pragmatic Trials of Tests"),
    sidebarLayout(
      sidebarPanel(
        fileInput("data_csv_input", "上传 CSV 文件", accept = c(".csv")),
        fileInput("data_excel_input", "上传 Excel 文件", accept = c(".xlsx")),
        actionButton("run_estimate", "计算参数"),
        actionButton("default_data", "使用默认数据"),
        hr(),
        h4("数据格式要求："),
        p("请确保数据格式如下："),
        tags$ul(
          tags$li("第一列为 T（测试结果，0 表示阴性，1 表示阳性）。"),
          tags$li("第二列为 B（目标病症状态，0 表示缺乏，1 表示存在）。"),
          tags$li("第三列为 A（患者分配的治疗，0 或 1）。"),
          tags$li("第四列为 Y（主要结果变量）。")
        ),
        hr(),
        h4("变量说明："),
        p("让 Y 为主要关注的结果变量。"),
        p("让 T、B 和 A 为二元变量，其中："),
        tags$ul(
          tags$li("T 是测试结果，阴性和阳性分别表示为 T = 0 和 T = 1。"),
          tags$li("B 是目标病症的状态，测试分类为 B = 0（缺乏）和 B = 1（存在）。"),
          tags$li("A 是分配给患者的治疗。")
        ),
        hr(),
        h4("输出结果说明："),
        p("以下为输出结果的详细说明："),
        tags$ul(
          tags$li("θabc = E(Y|A = a, B = b, T = t)：给定 A、B 和 T 的情况下 Y 的期望结果。"),
          tags$li("在 NDME 下：θabt = E(Y|A=a, B=b) = θab。"),
          tags$li("根据全概率法则，仅根据测试结果的期望结果为：θa·t = E(Y|A = a, T = t) = (1 - pt)θa0 + ptθa1，"),
          tags$li("其中 pt = Pr(B = 1|T = 1)。"),
          tags$li("在接受治疗 A = a 的患者中，生物标志物 B 的预后效应为：ηa = θa1 - θa0。"),
          tags$li("测试对分类生物标志物状态的预后效应为：η∗a = θa·1 - θa−·0 = (p1 - p0)(θa1 - θa0)，"),
          tags$li("其中 f = p1 - p0 = PPV + NPV - 1。"),
          tags$li("生物标志物值 B = b 的预测效应定义为：δb = θ1b - θ0b。"),
          tags$li("生物标志物的效应修饰由生物标志物与治疗的交互效应量化：∆ = δ1 - δ0。"),
          tags$li("测试结果 T = t 的预测效应为：δ·t = θ1·t - θ0·t = δ0 + pt(δ1 - δ0)。"),
          tags$li("测试的效应修饰由测试与治疗的交互效应量化：∆∗ = δ·1 - δ·0 = (p1 - p0)(δ1 - δ0)。")
        )
      ),
      mainPanel(
        h4("分析结果"),
        verbatimTextOutput("estimate_results"),
        verbatimTextOutput("default_data_display"),
     
      )
    )
  )
)













# 第二个子页面的 UI 设计
estimate_ui_2 <- tabPanel(
  title = "Discordant Pairs Design",
  fluidPage(
    titlePanel("Discordant Pairs Design"),
    sidebarLayout(
      sidebarPanel(
        fileInput("data_csv_input_2", "上传 CSV 文件", accept = c(".csv")),
        fileInput("data_excel_input_2", "上传 Excel 文件", accept = c(".xlsx")),
        actionButton("run_estimate_2", "计算参数"),
        actionButton("default_data_2", "使用默认数据"),
        hr(),
        h4("数据格式要求："),
        p("请确保数据格式如下："),
        tags$ul(
          tags$li("第一列为 S（状态变量，0 或 1），表示患者的状态。"),
          tags$li("第二列为 T（测试结果，0 表示阴性，1 表示阳性），表示测试结果。"),
          tags$li("第三列为 B（目标病症状态，0 表示缺乏，1 表示存在），表示生物标志物的状态。"),
          tags$li("第四列为 A（患者分配的治疗，0 或 1），表示患者接受的治疗。"),
          tags$li("第五列为 Y（主要结果变量），表示主要关注的结果。")
        ),
        hr(),
        h4("变量说明："),
        p("在不一致对照试验中，患者根据两种二元测试 S 和 T 的结果被随机分配到治疗 A = 0 或 1。"),
        p("具体说明："),
        tags$ul(
          tags$li("如果 S 和 T 的结果不一致，即一个为阳性，另一个为阴性，则患者随机分配到治疗 A。"),
          tags$li("如果 S 和 T 的结果一致，且都为阳性，则统一分配为 A = 1；如果都为阴性，则统一分配为 A = 0。"),
          tags$li("目标是理解测试 T 是否为基于测试 S 的治疗策略增加价值。")
        ),
        hr(),
        h4("输出结果说明："),
        p("以下为输出结果的详细说明："),
        tags$ul(
          tags$li("θabst = E(Y|A = a, B = b, S = s, T = t)：给定 A、B、S 和 T 的情况下 Y 的期望结果。"),
          tags$li("治疗效果为：δ·st = θ1·st - θ0·st，表示在 S 和 T 的特定结果下的治疗效果。"),
          tags$li("ΔDP = δ·01 - δ·10：表示不一致对照组中，S 和 T 的预测效果差异。"),
          tags$li("如果 ΔDP > 0，说明在 (S,T) = (0,1) 的患者中，治疗效果大于在 (1,0) 的患者中。")
        )
      ),
      mainPanel(
        h4("分析结果"),
        verbatimTextOutput("estimate_results_2"),
        verbatimTextOutput("default_data_display_2"),
        # 可以添加更多输出内容
      )
    )
  )
)









# 第三个子页面的 UI 设计
estimate_ui_3 <- tabPanel(
  title = "Test Strategy Design all treatment 0 in control ",
  fluidPage(
    titlePanel("Test Strategy Design all treatment 0 in control "),
    sidebarLayout(
      sidebarPanel(
        fileInput("data_csv_input_3", "上传 CSV 文件", accept = c(".csv")),
        fileInput("data_excel_input_3", "上传 Excel 文件", accept = c(".xlsx")),
        numericInput("missing_rate", "缺失率 (0 到 1)", value = 0.1, min = 0, max = 1, step = 0.01),
        actionButton("run_estimate_3", "计算参数"),
        actionButton("default_data_3", "使用默认数据"),
        hr(),
        h4("数据格式要求："),
        p("请确保数据格式如下："),
        tags$ul(
          tags$li("第一列为 T（测试结果，0 表示阴性，1 表示阳性，NA 表示缺失）。"),
          tags$li("第二列为 B（目标病症状态，0 表示缺乏，1 表示存在）。"),
          tags$li("第三列为 A（患者分配的治疗，0 或 1）。"),
          tags$li("第四列为 Y（主要结果变量）。")
        ),
        hr(),
        h4("变量说明："),
        p("在此页面中，缺失率用于模拟 T 变量的缺失情况。"),
        p("具体说明："),
        tags$ul(
          tags$li("如果 T 的值缺失，则患者被分配治疗 A = 0。"),
          tags$li("如果 T 的值为 0，则分配 A = 0；如果 T 的值为 1，则分配 A = 1。"),
          tags$li("目标是理解缺失数据对治疗效果的影响。")
        ),
        hr(),
        h4("输出结果说明："),
        p("以下为输出结果的详细说明："),
        tags$ul(
          tags$li("∆_{TS.UC} = Y 的均值（T 不是缺失值的组） - Y 的均值（T 是缺失值的组）。"),
          tags$li("此值表示缺失数据对治疗效果的影响程度。"),
          tags$li("注意，在计算差异 ∆TS.UC = ETS − EUC 时，项 (1−τ)θ0·0 被抵消。"),
          tags$li("该项表示在两个组中均接受治疗 0 的测试阴性患者子集，这会稀释两组间期望结果的差异，正好通过 τ 使 δ·1 减弱。")
        )
      ),
      mainPanel(
        h4("分析结果"),
        tableOutput("estimate_results_3"),
        # 可以添加更多输出内容
      )
    )
  )
)










# 第四个子页面的 UI 设计
estimate_ui_4 <- tabPanel(
  title = "Test Strategy Design random assignment in control",
  fluidPage(
    titlePanel("Test Strategy Design random assignment in control"),
    sidebarLayout(
      sidebarPanel(
        fileInput("data_csv_input_4", "上传 CSV 文件", accept = c(".csv")),
        fileInput("data_excel_input_4", "上传 Excel 文件", accept = c(".xlsx")),
        numericInput("missing_rate_4", "缺失率 (0 到 1)", value = 0.1, min = 0, max = 1, step = 0.01),
        numericInput("gamma", "对照组中分配到治疗0的概率", value = 0.5, min = 0, max = 1, step = 0.01),
        actionButton("run_estimate_4", "计算参数"),
        actionButton("default_data_4", "使用默认数据"),
        hr(),
        h4("数据格式要求："),
        p("请确保数据格式如下："),
        tags$ul(
          tags$li("第一列为 T（测试结果，0 表示阴性，1 表示阳性，NA 表示缺失）。"),
          tags$li("第二列为 B（目标病症状态，0 表示缺乏，1 表示存在）。"),
          tags$li("第三列为 A（患者分配的治疗，0 或 1）。"),
          tags$li("第四列为 Y（主要结果变量）。")
        ),
        hr(),
        h4("变量说明："),
        p("在此页面中，缺失率用于模拟 T 变量的缺失情况，gamma 用于控制对照组中治疗分配的概率。"),
        p("具体说明："),
        tags$ul(
          tags$li("如果 T 的值缺失，则患者根据概率 γ 被分配治疗 A = 0 或 A = 1。"),
          tags$li("如果 T 的值为 0，则分配 A = 0；如果 T 的值为 1，则分配 A = 1。"),
          tags$li("目标是理解缺失数据和治疗分配对结果的影响。")
        ),
        hr(),
        h4("输出结果说明："),
        p("以下为输出结果的详细说明："),
        tags$ul(
          tags$li("∆_{TS.RC} = Y 的均值（T 不是缺失值的组） - Y 的均值（T 是缺失值的组）。"),
          tags$li("此值表示缺失数据对治疗效果的影响程度。")
        )
      ),
      mainPanel(
        h4("分析结果"),
        tableOutput("estimate_results_4"),
        # 可以添加更多输出内容
      )
    )
  )
)








# 第五个子页面的 UI 设计
estimate_ui_5 <- tabPanel(
  title = "Comparative Test Strategy Design",
  fluidPage(
    titlePanel("Comparative Test Strategy Design"),
    sidebarLayout(
      sidebarPanel(
        fileInput("data_csv_input_5", "上传 CSV 文件", accept = c(".csv")),
        fileInput("data_excel_input_5", "上传 Excel 文件", accept = c(".xlsx")),
        actionButton("run_estimate_5", "计算参数"),
        actionButton("default_data_5", "使用默认数据"),
        hr(),
        h4("数据格式要求："),
        p("请确保数据格式如下："),
        tags$ul(
          tags$li("第一列为 S（测试结果，0 或 1）。"),
          tags$li("第二列为 T（测试结果，0 或 1）。"),
          tags$li("第三列为 B（目标病症状态，0 或 1）。"),
          tags$li("第四列为 Z（分配策略，0 或 1）。"),
          tags$li("第五列为 A（患者分配的治疗，0 或 1）。"),
          tags$li("第六列为 Y（主要结果变量）。")
        ),
        hr(),
        h4("变量说明："),
        p("在此页面中，治疗分配依据 Z 的值决定："),
        tags$ul(
          tags$li("如果 Z = 0，使用测试 T 的结果分配治疗 A；"),
          tags$li("如果 Z = 1，使用测试 S 的结果分配治疗 A。"),
          tags$li("目标是比较测试 S 和 T 对结果的影响。")
        ),
        hr(),
        h4("输出结果说明："),
        p("以下为输出结果的详细说明："),
        tags$ul(
          tags$li("∆_{CTS} = Y 的均值（Z = 0 组） - Y 的均值（Z = 1 组）。"),
          tags$li("此值表示不同测试策略对治疗效果的影响。")
        )
      ),
      mainPanel(
        h4("分析结果"),
        tableOutput("estimate_results_5"),
        # 可以添加更多输出内容
      )
    )
  )
)

