# 14_server_modules.R

library(readr)
library(readxl)

# 第一个子页面的 Server 逻辑
estimate_server_1 <- function(input, output, session) {
  
  observeEvent(input$run_estimate, {
    req(input$data_csv_input || input$data_excel_input)
    
    # 读取数据
    data <- NULL
    if (!is.null(input$data_csv_input)) {
      data <- read_csv(input$data_csv_input$datapath)
    } else if (!is.null(input$data_excel_input)) {
      data <- read_excel(input$data_excel_input$datapath)
    }
    
    # 预处理数据
    processed_data <- as.matrix(data)
    
    # 计算参数
    result <- estimate_parameters_1(processed_data)
    
    # 输出结果
    output$estimate_results <- renderPrint({
      print(result)
    })
  })
  
  observeEvent(input$default_data, {
    # 使用默认数据
    set.seed(123)  # 设置随机种子以确保结果可重复
    K <- 100  # 样本数
    theta_00 <- 0
    theta_01 <- 1
    theta_10 <- 2
    theta_11 <- 3
    
    # 生成模拟数据
    data <- generate_simulated_data_1(K, theta_00, theta_01, theta_10, theta_11)
    
    # 计算参数
    result <- estimate_parameters_1(data)
    
    # 输出结果
    output$estimate_results <- renderPrint({
      cat("使用默认数据计算的参数估计结果：\n")
      print(result)
    })
    
    # 显示默认数据结构
    output$default_data_display <- renderPrint({
      cat("默认数据示例（数据框形式）：\n")
      print(head(data))
    })
  })
}













# 第二个子页面的 Server 逻辑
estimate_server_2 <- function(input, output, session) {
  
  observeEvent(input$run_estimate_2, {
    req(input$data_csv_input_2 || input$data_excel_input_2)
    
    # 读取数据
    data <- NULL
    if (!is.null(input$data_csv_input_2)) {
      data <- read_csv(input$data_csv_input_2$datapath)
    } else if (!is.null(input$data_excel_input_2)) {
      data <- read_excel(input$data_excel_input_2$datapath)
    }
    
    # 预处理数据
    processed_data <- as.matrix(data)
    
    # 计算参数
    result <- estimate_parameters_2(processed_data)
    
    # 输出结果
    output$estimate_results_2 <- renderPrint({
      print(result)
    })
  })
  
  observeEvent(input$default_data_2, {
    # 使用默认数据
    set.seed(123)
    K <- 100
    theta_00 <- 0
    theta_01 <- 1
    theta_10 <- 2
    theta_11 <- 3
    
    data <- generate_simulated_data_2(K, theta_00, theta_01, theta_10, theta_11)
    
    result <- estimate_parameters_2(data)
    
    output$estimate_results_2 <- renderPrint({
      cat("使用默认数据计算的参数估计结果：\n")
      print(result)
    })
  })
}









# 14_server_modules.R

# 第三个子页面的 Server 逻辑
estimate_server_3 <- function(input, output, session) {
  
  observeEvent(input$run_estimate_3, {
    req(input$data_csv_input_3 || input$data_excel_input_3)
    
    # 读取数据
    data <- read_data(input)
    req(data)  # 确保数据存在
    
    # 生成模拟数据
    K <- nrow(data)
    theta_00 <- 0
    theta_01 <- 1
    theta_10 <- 2
    theta_11 <- 3
    missing_rate <- input$missing_rate
    
    simulated_data <- generate_simulated_data_3(K, theta_00, theta_01, theta_10, theta_11, missing_rate)
    
    # 计算 ∆_{TS.UC}
    result <- calculate_delta_TS_UC(simulated_data)
    
    # 输出结果
    output$estimate_results_3 <- renderTable({
      data.frame(Delta_TS_UC = result$Delta_TS_UC)
    })
  })
  
  observeEvent(input$default_data_3, {
    # 使用默认数据逻辑，这里可以根据需求定义默认参数和数据
    set.seed(123)
    K <- 100
    theta_00 <- 0
    theta_01 <- 1
    theta_10 <- 2
    theta_11 <- 3
    missing_rate <- 0.1
    
    data <- generate_simulated_data_3(K, theta_00, theta_01, theta_10, theta_11, missing_rate)
    result <- calculate_delta_TS_UC(data)
    
    output$estimate_results_3 <- renderTable({
      data.frame(Delta_TS_UC = result$Delta_TS_UC)
    })
  })
}









# 14_server_modules.R

# 第四个子页面的 Server 逻辑
estimate_server_4 <- function(input, output, session) {
  
  observeEvent(input$run_estimate_4, {
    req(input$data_csv_input_4 || input$data_excel_input_4)
    
    # 读取数据
    data <- read_data(input)
    req(data)  # 确保数据存在
    
    # 生成模拟数据
    K <- nrow(data)
    theta_00 <- 0
    theta_01 <- 1
    theta_10 <- 2
    theta_11 <- 3
    missing_rate <- input$missing_rate_4
    gamma <- input$gamma
    
    simulated_data <- generate_simulated_data_4(K, theta_00, theta_01, theta_10, theta_11, missing_rate, gamma)
    
    # 计算 ∆_{TS.RC}
    result <- calculate_delta_TS_RC(simulated_data)
    
    # 输出结果
    output$estimate_results_4 <- renderTable({
      data.frame(Delta_TS_RC = result$Delta_TS_RC)
    })
  })
  
  observeEvent(input$default_data_4, {
    # 使用默认数据逻辑，这里可以根据需求定义默认参数和数据
    set.seed(123)
    K <- 100
    theta_00 <- 0
    theta_01 <- 1
    theta_10 <- 2
    theta_11 <- 3
    missing_rate <- 0.1
    gamma <- 0.5
    
    data <- generate_simulated_data_4(K, theta_00, theta_01, theta_10, theta_11, missing_rate, gamma)
    result <- calculate_delta_TS_RC(data)
    
    output$estimate_results_4 <- renderTable({
      data.frame(Delta_TS_RC = result$Delta_TS_RC)
    })
  })
}























# 14_server_modules.R

# 第五个子页面的 Server 逻辑
estimate_server_5 <- function(input, output, session) {
  
  observeEvent(input$run_estimate_5, {
    req(input$data_csv_input_5 || input$data_excel_input_5)
    
    # 读取数据
    data <- read_data(input)
    req(data)  # 确保数据存在
    
    # 生成模拟数据
    K <- nrow(data)
    theta_00 <- 0
    theta_01 <- 1
    theta_10 <- 2
    theta_11 <- 3
    
    simulated_data <- generate_simulated_data_5(K, theta_00, theta_01, theta_10, theta_11)
    
    # 计算 ∆_{CTS}
    result <- calculate_delta_CTS(simulated_data)
    
    # 输出结果
    output$estimate_results_5 <- renderTable({
      data.frame(Delta_CTS = result$Delta_CTS)
    })
  })
  
  observeEvent(input$default_data_5, {
    # 使用默认数据逻辑，这里可以根据需求定义默认参数和数据
    set.seed(123)
    K <- 100
    theta_00 <- 0
    theta_01 <- 1
    theta_10 <- 2
    theta_11 <- 3
    
    data <- generate_simulated_data_5(K, theta_00, theta_01, theta_10, theta_11)
    result <- calculate_delta_CTS(data)
    
    output$estimate_results_5 <- renderTable({
      data.frame(Delta_CTS = result$Delta_CTS)
    })
  })
}
