library(shiny)

# 加载工具函数
source("14_utils.R")

# 加载 UI 模块
source("14_ui_modules.R")
# 加载 Server 模块
source("14_server_modules.R")

# 主应用程序
ui <- navbarPage("数据分析应用", 
                 estimate_ui_1,
                 estimate_ui_2,
                 estimate_ui_3,
                 estimate_ui_4,
                 estimate_ui_5)  # 添加参数估计的子页面

server <- function(input, output, session) {
  estimate_server_1(input, output, session)
  estimate_server_2(input, output, session)
  estimate_server_3(input, output, session)
  estimate_server_4(input, output, session)
  estimate_server_5(input, output, session)# 参数估计的 Server
}

# 运行 Shiny 应用
shinyApp(ui = ui, server = server)
