library(shiny)

# 加权标准差计算的 UI 设计
wsd_ui <- fluidPage(
  titlePanel("加权标准差计算"),
  
  sidebarLayout(
    sidebarPanel(
      fileInput("wsd_csv_input", "上传 CSV 文件", accept = c(".csv")),
      fileInput("wsd_excel_input", "上传 Excel 文件", accept = c(".xlsx")),
      actionButton("run_wsd", "运行分析"),
      actionButton("default_wsd", "使用默认数据"),
      hr(),
      h4("数据格式要求："),
      p("请确保数据格式如下："),
      tags$ul(
        tags$li("每行代表一个受试者，列代表测量次数。")
      )
    ),
    
    mainPanel(
      h4("结果"),
      verbatimTextOutput("wsd_results"),
      plotOutput("wsd_plot"),
      verbatimTextOutput("default_wsd_data_display")
    )
  )
)





# 第二个子页面的 UI 设计
rc_ui <- tabPanel(
  title = "重复性系数",
  fluidPage(
    titlePanel("重复性系数计算"),
    sidebarLayout(
      sidebarPanel(
        fileInput("rc_csv_input", "上传 CSV 文件", accept = c(".csv")),
        fileInput("rc_excel_input", "上传 Excel 文件", accept = c(".xlsx")),
        actionButton("run_rc", "计算重复性系数"),
        actionButton("default_rc", "使用默认数据"),
        hr(),
        h4("数据格式要求："),
        p("请确保数据格式如下："),
        tags$ul(
          tags$li("每行代表一个受试者，列代表测量次数。")
        )
      ),
      mainPanel(
        h4("分析结果"),
        verbatimTextOutput("rc_results"),
        h4("默认数据示例："),
        verbatimTextOutput("default_rc_data_display")
      )
    )
  )
)









# 第三个子页面的 UI 设计
wcv_ui <- tabPanel(
  title = "被试内变异系数",
  fluidPage(
    titlePanel("被试内变异系数计算"),
    sidebarLayout(
      sidebarPanel(
        fileInput("wcv_csv_input", "上传 CSV 文件", accept = c(".csv")),
        fileInput("wcv_excel_input", "上传 Excel 文件", accept = c(".xlsx")),
        numericInput("beta0", "输入 beta0 参数:", value = 0),  # 新增 beta0 输入框
        numericInput("beta1", "输入 beta1 参数:", value = 1),  # 新增 beta1 输入框
        actionButton("run_wcv", "计算被试内变异系数"),
        actionButton("default_wcv", "使用默认数据"),
        hr(),
        h4("数据格式要求："),
        p("请确保数据格式如下："),
        tags$ul(
          tags$li("每行代表一个受试者，列代表测量次数。")
        )
      ),
      mainPanel(
        h4("分析结果"),
        verbatimTextOutput("wcv_results"),
        h4("默认数据示例："),
        verbatimTextOutput("default_wcv_data_display")
      )
    )
  )
)








# 第四个子页面的 UI 设计
bias_ui <- tabPanel(
  title = "常数偏差估计",
  fluidPage(
    titlePanel("常数偏差估计计算"),
    sidebarLayout(
      sidebarPanel(
        fileInput("bias_csv_input", "上传 CSV 文件", accept = c(".csv")),
        fileInput("bias_excel_input", "上传 Excel 文件", accept = c(".xlsx")),
        textInput("X_values", "输入患者真实期望 X (用逗号分隔):", value = "0, 0, 0, 0, 0"),  # 输入 X 的文本框
        actionButton("run_bias", "计算常数偏差"),
        actionButton("default_bias", "使用默认数据"),
        hr(),
        h4("数据格式要求："),
        p("请确保数据格式如下："),
        tags$ul(
          tags$li("每行代表一个受试者，列代表测量次数。")
        )
      ),
      mainPanel(
        h4("分析结果"),
        verbatimTextOutput("bias_results"),
        h4("默认数据示例："),
        verbatimTextOutput("default_bias_data_display")
      )
    )
  )
)







# 第五个子页面的 UI 设计
ybias_ui <- tabPanel(
  title = "非恒定偏差估计",
  fluidPage(
    titlePanel("非恒定偏差估计计算"),
    sidebarLayout(
      sidebarPanel(
        fileInput("ybias_csv_input", "上传 CSV 文件", accept = c(".csv")),
        fileInput("ybias_excel_input", "上传 Excel 文件", accept = c(".xlsx")),
        textInput("X_values_ybias", "输入患者真实期望 X (用逗号分隔):", value = "0, 0, 0, 0, 0"),  # 输入 X 的文本框
        actionButton("run_ybias", "计算非恒定偏差"),
        actionButton("default_ybias", "使用默认数据"),
        hr(),
        h4("数据格式要求："),
        p("请确保数据格式如下："),
        tags$ul(
          tags$li("每行代表一个受试者，列代表测量次数。")
        )
      ),
      mainPanel(
        h4("分析结果"),
        verbatimTextOutput("ybias_results"),
        h4("默认数据示例："),
        verbatimTextOutput("default_ybias_data_display")
      )
    )
  )
)










# 第六个子页面的 UI 设计
cot_ui <- tabPanel(
  title = "时间变化估计",
  fluidPage(
    titlePanel("时间变化估计计算"),
    sidebarLayout(
      sidebarPanel(
        fileInput("cot_csv_input", "上传 CSV 文件", accept = c(".csv")),
        fileInput("cot_excel_input", "上传 Excel 文件", accept = c(".xlsx")),
        textInput("X_values_cot", "输入患者真实期望 X (用逗号分隔):", value = "0, 0, 0, 0, 0"),  # 输入 X 的文本框
        actionButton("run_cot", "计算时间变化"),
        actionButton("default_cot", "使用默认数据"),
        hr(),
        h4("数据格式要求："),
        p("请确保数据格式如下："),
        tags$ul(
          tags$li("每行代表一个受试者，列代表测量次数。")
        )
      ),
      mainPanel(
        h4("分析结果"),
        verbatimTextOutput("cot_results"),
        h4("默认数据示例："),
        verbatimTextOutput("default_cot_data_display")
      )
    )
  )
)