# 加权标准差计算函数
wSDi <- function(data, i) {
  k <- length(data[i, ])
  wSDi <- sqrt(sum((data[i, ] - mean(data[i, ]))^2) / (k - 1))
  return(wSDi)
}

wSD <- function(data) {
  n <- nrow(data)
  l <- ncol(data)
  temp <- numeric(n)
  
  for (i in 1:n) {
    temp[i] <- wSDi(data, i)
  }
  
  wSD <- sqrt(sum(temp^2) / n)
  lwSD <- sqrt(n * (l - 1) * wSD^2 / qchisq(0.975, df = n * (l - 1)))
  rwSD <- sqrt(n * (l - 1) * wSD^2 / qchisq(0.025, df = n * (l - 1)))
  
  return(c(wSD, lwSD, rwSD))
}




# 重复性系数函数
RC <- function(data) {
  n <- nrow(data)
  l <- ncol(data)
  wSDRC <- wSD(data)[1]
  RC <- 1.96 * sqrt(2 * wSDRC^2)
  lRC <- RC - RC * sqrt(n / qchisq(0.975, df = n * (l - 1)))
  rRC <- RC + RC * sqrt(n / qchisq(0.975, df = n * (l - 1)))
  return(c(RC, lRC, rRC))
}




# 被试内变异系数函数
wCV <- function(data){
  n <- nrow(data)
  l <- ncol(data)
  wsdi <- numeric(n)
  y <- numeric(n)
  
  for(i in 1:n){
    wsdi[i] <- wSDi(data, i)
    y[i] <- mean(data[i,])
  }
  
  wCV <- sqrt(sum(wsdi^2 / y^2) / n)
  lwCV <- sqrt(n * (l - 1) * wCV^2 / qchisq(0.975, df = n * (l - 1)))
  rwCV <- sqrt(n * (l - 1) * wCV^2 / qchisq(0.025, df = n * (l - 1)))
  
  return(c(wCV, lwCV, rwCV))
}

# 加权变异系数函数
wCVc <- function(data, beta1, beta0){
  n <- nrow(data)
  l <- ncol(data)
  wsdi <- numeric(n)
  y <- numeric(n)
  
  for(i in 1:n){
    wsdi[i] <- wSDi(data, i)
    y[i] <- mean(data[i,])
  }
  
  wCVc <- sqrt(sum((wsdi * beta1)^2 / (y - beta0)^2) / n)
  return(wCVc)
}







# 常数偏差估计函数
Di <- function(data, i, Xi) {
  Di <- mean(data[i, ]) - Xi
  percentDi <- Di / Xi
  return(c(Di, percentDi))
}

D <- function(data, X) {
  n <- nrow(data)
  D_i <- numeric(n)
  percentD_i <- numeric(n)
  
  for(i in 1:n) {
    D_i[i] <- Di(data, i, X[i])[1]
    percentD_i[i] <- Di(data, i, X[i])[2]
  }
  
  D <- mean(D_i)
  percentD <- mean(percentD_i)
  return(c(D, percentD))
}

VarD <- function(data, X) {
  Dhat <- D(data, X)[1]
  n <- nrow(data)
  D_i <- numeric(n)
  
  for(i in 1:n) {
    D_i[i] <- Di(data, i, X[i])[1]
  }
  
  VarD <- sum((D_i - Dhat)^2) / (n - 1)
  lD <- Dhat + qt(p = 0.025, df = n - 1) * sqrt(VarD)
  rD <- Dhat - qt(p = 0.025, df = n - 1) * sqrt(VarD)
  return(c(VarD, lD, rD))
}



# 13_utils.R

# 非恒定偏差估计函数
Ybias <- function(data, X) {
  n <- nrow(data)
  l <- ncol(data)
  temp <- matrix(data, nrow = n * l, ncol = 2, byrow = FALSE)
  temp[, 2] <- rep(X, each = l)  # 确保 X 向量重复以匹配数据
  colnames(temp) <- c("y", "x")
  temp <- as.data.frame(temp)
  
  test <- lm(y ~ x, data = temp)
  beta1 <- coef(test)[2]
  beta0 <- coef(test)[1]
  
  if(beta1 > 0){
    lY <- (data - beta0) / beta1 - 1.96 * wSD(data)[1] / beta1
    rY <- (data - beta0) / beta1 + 1.96 * wSD(data)[1] / beta1
  }else if(beta1 < 0){
    rY <- (data - beta0) / beta1 - 1.96 * wSD(data)[1] / beta1
    lY <- (data - beta0) / beta1 + 1.96 * wSD(data)[1] / beta1
 }
  
  
  return(list(lY = lY, rY = rY))
}











# 13_utils.R

# 时间变化估计函数
CoT <- function(data, X) {
  n <- nrow(data)
  l <- ncol(data)
  temp <- matrix(data, nrow = n * l, ncol = 2, byrow = FALSE)
  temp[, 2] <- rep(X, each = l)  # 确保 X 向量重复以匹配数据
  colnames(temp) <- c("y", "x")
  temp <- as.data.frame(temp)
  
  test <- lm(y ~ x, data = temp)
  beta1 <- coef(test)[2]
  beta0 <- coef(test)[1]
  
  CoT <- (data[, 2] - data[, 1]) / beta1
  lCoT <- CoT - 1.96 * sqrt(2 * wSD(data)[1]^2 / beta1^2)
  rCoT <- CoT + 1.96 * sqrt(2 * wSD(data)[1]^2 / beta1^2)
  
  return(list(CoT = CoT, lCoT = lCoT, rCoT = rCoT))
}