library(shiny)
library(readr)
library(readxl)
library(ggplot2)

# 加载工具函数
source("13_utils.R")

# 加载 UI 模块
source("13_ui_modules.R")
# 加载 Server 模块
source("13_server_modules.R")

# 主应用程序
ui <- navbarPage("Chapter13", 
                 tabPanel("加权标准差计算", wsd_ui),
                 tabPanel("重复性系数计算", rc_ui),
                 tabPanel("被试内变异系数计算", wcv_ui),
                 tabPanel("常数偏差估计", bias_ui),
                 tabPanel("非恒定偏差估计", ybias_ui),
                 tabPanel("时间变化估计", cot_ui))  # 添加 cot_ui

server <- function(input, output, session) {
  wsd_server(input, output, session)  # 加权标准差计算的 Server
  rc_server(input, output, session)    # 重复性系数计算的 Server
  wcv_server(input, output, session)    # 被试内变异系数计算的 Server
  bias_server(input, output, session)    # 常数偏差估计的 Server
  ybias_server(input, output, session)   # 非恒定偏差估计的 Server
  cot_server(input, output, session)     # 时间变化估计的 Server
}

# 运行 Shiny 应用
shinyApp(ui = ui, server = server)