library(readxl)

# 解析用户输入的文本数据
parse_text_input <- function(X_text, Y_text, C_text, c_text) {
  X <- as.numeric(strsplit(X_text, ", ")[[1]])
  Y <- as.numeric(strsplit(Y_text, ", ")[[1]])
  C <- as.numeric(strsplit(C_text, ", ")[[1]])
  c <- as.numeric(c_text)
  Z <- cbind(Y, C)
  return(list(X = X, Z = Z, c = c))
}

# 处理CSV文件
process_csv_input <- function(file) {
  data <- read.csv(file$datapath)
  X <- data$X
  Y <- data$Y
  C <- data$C
  c <- data$c
  Z <- cbind(Y, C)
  return(list(X = X, Z = Z, c = c))
}

# 处理Excel文件
process_excel_input <- function(file) {
  data <- read_excel(file$datapath)
  X <- data$X
  Y <- data$Y
  C <- data$C
  c <- data$c
  Z <- cbind(Y, C)
  return(list(X = X, Z = Z, c = c))
}