library(shiny)

# UI 设计
ui <- fluidPage(
  titlePanel("ROI Analysis App"),
  
  sidebarLayout(
    sidebarPanel(
      fileInput("data_file", "上传 CSV 或 Excel 文件", 
                accept = c(".csv", ".xlsx")),
      actionButton("run_analysis", "运行分析"),
      actionButton("use_default", "使用默认数据"),
      hr(),
      h4("数据格式要求："),
      p("请确保数据格式如下："),
      tags$ul(
        tags$li("第一列：y（感染ROI评分）"),
        tags$li("第二列：x（非感染ROI评分）")
      )
    ),
    
    mainPanel(
      h4("ROI 曲线和结果"),
      plotOutput("roi_plot"),
      verbatimTextOutput("results")
    )
  )
)