library(shiny)

# 第一个子页面的UI
ui1 <- tabPanel("LROC Approach",
                titlePanel("LROC Approach"),
                
                sidebarLayout(
                  sidebarPanel(
                    h4("Instructions:"),
                    p("X表示正常病例的置信得分，Y表示患病个体的置信得分，C表示患病个体中患病区域的位置标注是否正确，c表示置信得分的阈值，超过该阈值则认为阳性。"),
                    textInput("X_input", "X:", value = "1, 2, 3, 4, 5"),
                    textInput("Y_input", "Y:", value = "2, 3, 4, 5"),
                    textInput("C_input", "C:", value = "1, 1, 0, 1"),
                    textInput("c_input", "c:", value = "3"),
                    fileInput("csv_input", "Upload CSV File", accept = ".csv"),
                    fileInput("excel_input", "Upload Excel File", accept = c(".xls", ".xlsx")),
                    actionButton("run", "Run")
                  ),
                  
                  mainPanel(
                    h4("Results:"),
                    verbatimTextOutput("results")
                  )
                )
)

# 第二个子页面的UI
ui2 <- tabPanel("Nonparametric LROC Approach",
                titlePanel("Nonparametric LROC Approach"),
                
                sidebarLayout(
                  sidebarPanel(
                    h4("Instructions:"),
                    p("X表示正常病例的置信得分，Y表示患病个体的置信得分，C表示患病个体中患病区域的位置标注是否正确，c表示置信得分的阈值，超过该阈值则认为阳性。"),
                    textInput("X_input_np", "X:", value = "1, 2, 3, 4, 5"),
                    textInput("Y_input_np", "Y:", value = "2, 3, 4, 5"),
                    textInput("C_input_np", "C:", value = "1, 1, 0, 1"),
                    textInput("c_input_np", "c:", value = "3"),
                    fileInput("csv_input_np", "Upload CSV File", accept = ".csv"),
                    fileInput("excel_input_np", "Upload Excel File", accept = c(".xls", ".xlsx")),
                    actionButton("run_np", "Run")
                  ),
                  
                  mainPanel(
                    h4("Results:"),
                    verbatimTextOutput("results_np"),
                    plotOutput("density_plot_np"),
                    plotOutput("cumulative_plot_np")
                  )
                )
)

# 第三个子页面的UI
ui3 <- tabPanel("ALROC and SigmaL",
                titlePanel("Calculate ALROC and SigmaL"),
                
                sidebarLayout(
                  sidebarPanel(
                    h4("Instructions:"),
                    p("X表示正常病例的置信得分，Y表示患病个体的置信得分，C表示患病个体中患病区域的位置标注是否正确，c表示置信得分的阈值，超过该阈值则认为阳性。"),
                    textInput("X_input_alroc", "X:", value = "1, 2, 3, 4, 5"),
                    textInput("Y_input_alroc", "Y:", value = "2, 3, 4, 5"),
                    textInput("C_input_alroc", "C:", value = "1, 1, 0, 1"),
                    textInput("c_input_alroc", "c:", value = "3"),
                    fileInput("csv_input_alroc", "Upload CSV File", accept = ".csv"),
                    fileInput("excel_input_alroc", "Upload Excel File", accept = c(".xls", ".xlsx")),
                    actionButton("run_alroc", "Run")
                  ),
                  
                  mainPanel(
                    h4("Results:"),
                    verbatimTextOutput("results_alroc")
                  )
                )
)
