library(shiny)

# FROC 计算的UI
froc_ui <- tabPanel("FROC Approach",
                    titlePanel("FROC Approach"),
                    
                    sidebarLayout(
                      sidebarPanel(
                        h4("输入数据格式要求："),
                        p("请确保您的数据格式如下："),
                        tags$ol(
                          tags$li("第一列：CaseID（病例唯一标识符）"),
                          tags$li("第二列：Status（病例状态，值为 'Positive' 或 'Negative'）"),
                          tags$li("第三列：LesionCount（阳性病例的病灶数量）"),
                          tags$li("第四列：Marked1（病灶的标记，值为 1 或 0）"),
                          tags$li("第五列：Confidence1（病灶的置信分数）"),
                          tags$li("第六列：FalsePositivesCount（阳性病例中的错误定位数量）"),
                          tags$li("第七列：FPConfidence1（错误定位的置信分数）")
                        ),
                        fileInput("froc_csv_input", "上传 CSV 文件", accept = ".csv"),
                        fileInput("froc_excel_input", "上传 Excel 文件", accept = c(".xls", ".xlsx")),
                        actionButton("run_froc", "Run"),
                        hr(),
                        h4("使用默认数据"),
                        actionButton("default_froc", "Run"),
                        verbatimTextOutput("default_froc_data_display")  # 显示默认数据
                      ),
                      
                      mainPanel(
                        h4("计算结果："),
                        verbatimTextOutput("froc_results"),
                        plotOutput("froc_plot")
                      )
                    )
)

# Inferred ROC Analysis的UI
iroc_ui <- tabPanel("Inferred ROC Analysis",
                    titlePanel("Inferred ROC Analysis"),
                    
                    sidebarLayout(
                      sidebarPanel(
                        h4("输入数据格式要求："),
                        p("请确保您的数据格式如下："),
                        tags$ol(
                          tags$li("第一列：CaseID（病例唯一标识符）"),
                          tags$li("第二列：Status（病例状态，值为 'Positive' 或 'Negative'）"),
                          tags$li("第三列：LesionCount（阳性病例的病灶数量）"),
                          tags$li("第四列：Marked1（病灶的标记，值为 1 或 0）"),
                          tags$li("第五列：Confidence1（病灶的置信分数）"),
                          tags$li("第六列：FalsePositivesCount（阳性病例中的错误定位数量）"),
                          tags$li("第七列：FPConfidence1（错误定位的置信分数）")
                        ),
                        p("示例数据结构如下："),
                        verbatimTextOutput("example_data_structure"),
                        fileInput("iroc_csv_input", "上传 CSV 文件", accept = ".csv"),
                        fileInput("iroc_excel_input", "上传 Excel 文件", accept = c(".xls", ".xlsx")),
                        actionButton("run_iroc", "Run"),
                        hr(),
                        h4("使用默认数据"),
                        actionButton("default_iroc", "Run"),
                        verbatimTextOutput("default_iroc_data_display")  # 显示默认数据
                      ),
                      
                      mainPanel(
                        h4("计算结果："),
                        verbatimTextOutput("iroc_results"),
                        plotOutput("iroc_plot")
                      )
                    )
)









afroc_ui <- tabPanel("AFROC Curve",
                     titlePanel("AFROC Curve 计算"),
                     
                     sidebarLayout(
                       sidebarPanel(
                         h4("输入数据格式要求："),
                         p("请确保您的数据格式如下："),
                         tags$ol(
                           tags$li("第一列：CaseID（病例唯一标识符）"),
                           tags$li("第二列：Status（病例状态，值为 'Positive' 或 'Negative'）"),
                           tags$li("第三列：LesionCount（阳性病例的病灶数量）"),
                           tags$li("第四列：Marked1（病灶的标记，值为 1 或 0）"),
                           tags$li("第五列：Confidence1（病灶的置信分数）"),
                           tags$li("第六列：FalsePositivesCount（阳性病例中的错误定位数量）"),
                           tags$li("第七列：FPConfidence1（错误定位的置信分数）")
                         ),
                         p("示例数据结构如下："),
                         verbatimTextOutput("example_afroc_data_structure"),
                         fileInput("afroc_csv_input", "上传 CSV 文件", accept = ".csv"),
                         fileInput("afroc_excel_input", "上传 Excel 文件", accept = c(".xls", ".xlsx")),
                         actionButton("calculate_afroc", "计算 AFROC Curve"),
                         hr(),
                         h4("使用默认数据"),
                         actionButton("default_afroc", "Run"),
                         verbatimTextOutput("default_afroc_data_display")  # 显示默认数据
                       ),
                       
                       mainPanel(
                         h4("计算结果："),
                         verbatimTextOutput("afroc_result"),
                         plotOutput("afroc_plot")
                       )
                     )
)













resampling_ui <- tabPanel("Resampling Methods",
                          titlePanel("Resampling Methods"),
                          
                          sidebarLayout(
                            sidebarPanel(
                              h4("输入数据格式要求："),
                              p("请确保您的数据格式如下："),
                              tags$ol(
                                tags$li("第一列：CaseID（病例唯一标识符）"),
                                tags$li("第二列：Status（病例状态，值为 'Positive' 或 'Negative'）"),
                                tags$li("第三列：LesionCount（阳性病例的病灶数量）"),
                                tags$li("第四列：Lesions（每个阳性病例的病灶数据）"),
                                tags$li("第五列：Confidence（每个阳性病例的置信分数）"),
                                tags$li("第六列：FalsePositivesCount（阳性病例中的错误定位数量）"),
                                tags$li("第七列：FalsePositiveConfidence（错误定位的置信分数）")
                              ),
                              p("示例数据结构如下："),
                              verbatimTextOutput("example_resampling_data_structure"),
                              fileInput("resampling_csv_input", "上传 CSV 文件", accept = ".csv"),
                              fileInput("resampling_excel_input", "上传 Excel 文件", accept = c(".xls", ".xlsx")),
                              numericInput("bootstrap_samples", "Bootstrap 样本数量", value = 1000, min = 1),
                              actionButton("run_resampling", "计算 FAUC"),
                              hr(),
                              h4("使用默认数据"),
                              actionButton("default_resampling", "使用默认数据"),
                              verbatimTextOutput("default_resampling_data_display")  # 显示默认数据
                            ),
                            
                            mainPanel(
                              h4("计算结果："),
                              verbatimTextOutput("resampling_results"),
                                 )
                          )
)
