library(shiny)
library(readr)
library(readxl)
library(ggplot2)

# FROC 计算的Server
froc_server <- function(input, output, session) {
  observeEvent(input$run_froc, {
    req(input$froc_csv_input || input$froc_excel_input)
    
    if (!is.null(input$froc_csv_input)) {
      data <- read_csv(input$froc_csv_input$datapath)
    } else if (!is.null(input$froc_excel_input)) {
      data <- read_excel(input$froc_excel_input$datapath)
    }
    
    # 预处理数据
    processed_data <- preprocess_data(data)
    
    # 提取数据
    t <- processed_data$t
    L <- processed_data$L
    X <- processed_data$X
    n1 <- processed_data$n1
    Y1 <- processed_data$Y1
    n0 <- processed_data$n0
    Y0 <- processed_data$Y0
    
    
    
    
    
    result <- calculate_and_plot_FROC_with_AF(t, L, X, n1, Y1, n0, Y0)
    
    # 输出结果
    output$froc_results <- renderPrint({
      cat("A_F:", result$A_F, "\n")
      cat("LLF(ζ):", result$LLF, "\n")
      cat("NLF(ζ):", result$NLF, "\n")
    })
    
    # 绘图输出
    output$froc_plot <- renderPlot({
      ggplot(data.frame(NLF = result$NLF, LLF = result$LLF), aes(x = NLF, y = LLF)) +
        geom_line() +
        geom_point() +
        labs(title = "FROC Curve", x = "NLF(ζ)", y = "LLF(ζ)") +
        theme_minimal()
    })
  })
  
  
  observeEvent(input$default_froc, {
    # 使用默认数据
    t <- c(5, 4, 6, 3, 7)
    L <- list(c(1, 0, 1, 1, 0),
              c(0, 1, 1, 0),
              c(1, 0, 1, 1, 0, 1),
              c(1, 0, 1),
              c(1, 0, 1, 1, 0, 1, 1))
    X <- list(c(0.8, 0, 0.9, 0.7, 0),
              c(0, 0.7, 0.8, 0),
              c(0.6, 0, 0.8, 0.9, 0, 0.7),
              c(0.8, 0, 0.9),
              c(0.7, 0, 0.8, 0.9, 0, 0.7, 0.8))
    n1 <- c(3, 2, 4, 1, 5)
    Y1 <- list(c(0.5, 0.6, 0.7),
               c(0.7, 0.8),
               c(0.4, 0.5, 0.6, 0.7),
               c(0.8),
               c(0.5, 0.6, 0.7, 0.8, 0.9))
    n0 <- c(2, 3, 1, 2, 4)
    Y0 <- list(c(0.3, 0.4),
               c(0.4, 0.5, 0.6),
               c(0.3),
               c(0.4, 0.5),
               c(0.3, 0.4, 0.5, 0.6))
    
    result <- calculate_and_plot_FROC_with_AF(t, L, X, n1, Y1, n0, Y0)
    
    # 输出结果
    output$froc_results <- renderPrint({
      cat("A_F:", result$A_F, "\n")
      cat("LLF(ζ):", result$LLF, "\n")
      cat("NLF(ζ):", result$NLF, "\n")
    })
    
    # 绘图输出
    output$froc_plot <- renderPlot({
      ggplot(data.frame(NLF = result$NLF, LLF = result$LLF), aes(x = NLF, y = LLF)) +
        geom_line() +
        geom_point() +
        labs(title = "FROC Curve", x = "NLF(ζ)", y = "LLF(ζ)") +
        theme_minimal()
    })
    # 显示默认数据
    output$default_froc_data_display <- renderPrint({
      cat("默认数据示例：\n")
      cat("t <- c(", paste(t, collapse = ", "), ")\n")
      cat("L <- list(", paste(sapply(L, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
      cat("X <- list(", paste(sapply(X, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
      cat("n1 <- c(", paste(n1, collapse = ", "), ")\n")
      cat("Y1 <- list(", paste(sapply(Y1, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
      cat("n0 <- c(", paste(n0, collapse = ", "), ")\n")
      cat("Y0 <- list(", paste(sapply(Y0, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
    })

  })
}




















# Inferred ROC Analysis的Server
iroc_server <- function(input, output, session) {
  
  observeEvent(input$run_iroc, {
    req(input$iroc_csv_input || input$iroc_excel_input)
    
    if (!is.null(input$iroc_csv_input)) {
      data <- read_csv(input$iroc_csv_input$datapath)
    } else if (!is.null(input$iroc_excel_input)) {
      data <- read_excel(input$iroc_excel_input$datapath)
    }
    
    # 预处理数据
    processed_data <- preprocess_data(data)
    
    # 提取数据
    t <- processed_data$t
    L <- processed_data$L
    X <- processed_data$X
    n1 <- processed_data$n1
    Y1 <- processed_data$Y1
    n0 <- processed_data$n0
    Y0 <- processed_data$Y0
    
    # 调用推断 ROC 计算函数
    result <- calculate_and_plot_iROC_with_AiR(t, L, X, n1, Y1, n0, Y0)
    
    # 输出结果
    output$iroc_results <- renderPrint({
      cat("TPF_iR:", result$TPF_iR, "\n")
      cat("FPF_iR:", result$FPF_iR, "\n")
      cat("A_iR:", result$A_iR, "\n")
    })
    
    # 绘图输出
    output$iroc_plot <- renderPlot({
      ggplot(data.frame(FPF_iR = result$FPF_iR, TPF_iR = result$TPF_iR), aes(x = FPF_iR, y = TPF_iR)) +
        geom_line() +
        geom_point() +
        labs(title = "iROC 曲线", x = "FPF_iR(ζ)", y = "TPF_iR(ζ)") +
        xlim(0, 1) +
        ylim(0, 1) +
        theme_minimal()
    })
  })
  
  observeEvent(input$default_iroc, {
    # 使用默认数据
    t <- c(3, 2, 3, 1, 3, 2, 3, 1, 2, 3, 3, 2, 3, 1, 3, 2, 3, 1, 2, 3)
    L <- list(
      c(1, 0, 1),
      c(0, 1),
      c(1, 0, 1),
      c(1),
      c(1, 0, 1),
      c(0, 1),
      c(1, 0, 1),
      c(1),
      c(0, 1),
      c(1, 0, 1),
      c(1, 0, 1),
      c(0, 1),
      c(1, 0, 1),
      c(1),
      c(1, 0, 1),
      c(0, 1),
      c(1, 0, 1),
      c(1),
      c(0, 1),
      c(1, 0, 1)
    )
    X <- list(
      c(0.8, 0, 0.9),
      c(0, 0.7),
      c(0.6, 0, 0.8),
      c(0.8),
      c(0.7, 0, 0.9),
      c(0, 0.7),
      c(0.6, 0, 0.8),
      c(0.8),
      c(0, 0.7),
      c(0.7, 0, 0.9),
      c(0.8, 0, 0.9),
      c(0, 0.7),
      c(0.6, 0, 0.8),
      c(0.8),
      c(0.7, 0, 0.9),
      c(0, 0.7),
      c(0.6, 0, 0.8),
      c(0.8),
      c(0, 0.7),
      c(0.7, 0, 0.9)
    )
    n1 <- c(2, 0, 2, 0, 2, 0, 2, 0, 0, 2, 2, 0, 2, 0, 2, 0, 2, 0, 0, 2)
    Y1 <- list(
      c(0.5, 0.6),
      numeric(0),
      c(0.4, 0.5),
      numeric(0),
      c(0.5, 0.6),
      numeric(0),
      c(0.4, 0.5),
      numeric(0),
      numeric(0),
      c(0.5, 0.6),
      c(0.5, 0.6),
      numeric(0),
      c(0.4, 0.5),
      numeric(0),
      c(0.5, 0.6),
      numeric(0),
      c(0.4, 0.5),
      numeric(0),
      numeric(0),
      c(0.5, 0.6)
    )
    n0 <- c(2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2)
    Y0 <- list(
      c(0.3, 0.4),
      c(0.3),
      c(0.3, 0.4),
      c(0.3),
      c(0.3, 0.4),
      c(0.3),
      c(0.3, 0.4),
      c(0.3),
      c(0.3),
      c(0.3, 0.4),
      c(0.3, 0.4),
      c(0.3),
      c(0.3, 0.4),
      c(0.3),
      c(0.3, 0.4),
      c(0.3),
      c(0.3, 0.4),
      c(0.3),
      c(0.3),
      c(0.3, 0.4)
    )
    
    # 调用推断 ROC 计算函数
    result <- calculate_and_plot_iROC_with_AiR(t, L, X, n1, Y1, n0, Y0)
    
    # 输出结果
    output$iroc_results <- renderPrint({
      cat("TPF_iR:", result$TPF_iR, "\n")
      cat("FPF_iR:", result$FPF_iR, "\n")
      cat("A_iR:", result$A_iR, "\n")
    })
    
    # 绘图输出
    output$iroc_plot <- renderPlot({
      ggplot(data.frame(FPF_iR = result$FPF_iR, TPF_iR = result$TPF_iR), aes(x = FPF_iR, y = TPF_iR)) +
        geom_line() +
        geom_point() +
        labs(title = "iROC 曲线", x = "FPF_iR(ζ)", y = "TPF_iR(ζ)") +
        xlim(0, 1) +
        ylim(0, 1) +
        theme_minimal()
    })
    
    # 显示默认数据
    output$default_iroc_data_display <- renderPrint({
      cat("默认数据示例：\n")
      cat("t <- c(", paste(t, collapse = ", "), ")\n")
      cat("L <- list(", paste(sapply(L, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
      cat("X <- list(", paste(sapply(X, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
      cat("n1 <- c(", paste(n1, collapse = ", "), ")\n")
      cat("Y1 <- list(", paste(sapply(Y1, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
      cat("n0 <- c(", paste(n0, collapse = ", "), ")\n")
      cat("Y0 <- list(", paste(sapply(Y0, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
    })
  })
}
















# AFROC Analysis的Server
afroc_server <- function(input, output, session) {
  
  observeEvent(input$run_afroc, {
    req(input$afroc_csv_input || input$afroc_excel_input)
    
    if (!is.null(input$afroc_csv_input)) {
      data <- read_csv(input$afroc_csv_input$datapath)
    } else if (!is.null(input$afroc_excel_input)) {
      data <- read_excel(input$afroc_excel_input$datapath)
    }
    
    # 预处理数据
    processed_data <- preprocess_data(data)
    
    # 提取数据
    t <- processed_data$t
    L <- processed_data$L
    X <- processed_data$X
    n1 <- processed_data$n1
    Y1 <- processed_data$Y1
    n0 <- processed_data$n0
    Y0 <- processed_data$Y0
    
    result <- calculate_and_plot_AFROC_with_AAF(t, L, X, n1, Y1, n0, Y0)
  
    # 输出结果
      output$afroc_result <- renderPrint({
      cat("AAF:", result$AAF, "\n")
      cat("LLFA values:", paste(result$LLFA, collapse = ", "), "\n")
      cat("FPFA values:", paste(result$FPFA, collapse = ", "), "\n")
    })
    
    
    
    
    # 绘图输出
    output$afroc_plot <- renderPlot({
      ggplot(data.frame(FPFA = result$FPFA, LLFA = result$LLFA), aes(x = FPFA, y = LLFA)) +
        geom_line() +
        geom_point() +
        labs(title = "AFROC 曲线", x = "FPFA(ζ)", y = "LLFA(ζ)") +
        xlim(0, 1) +
        ylim(0, 1) +
        theme_minimal()
    })
  })
  
  observeEvent(input$default_afroc, {
    # 使用默认数据
    t <- c(3, 2, 3, 1, 3, 2, 3, 1, 2, 3, 3, 2, 3, 1, 3, 2, 3, 1, 2, 3)  # 阳性病例的病灶个数，每个不超过3个
    L <- list(
      c(1, 0, 1),
      c(0, 1),
      c(1, 0, 1),
      c(1),
      c(1, 0, 1),
      c(0, 1),
      c(1, 0, 1),
      c(1),
      c(0, 1),
      c(1, 0, 1),
      c(1, 0, 1),
      c(0, 1),
      c(1, 0, 1),
      c(1),
      c(1, 0, 1),
      c(0, 1),
      c(1, 0, 1),
      c(1),
      c(0, 1),
      c(1, 0, 1)
    )  # 每个阳性病例的病灶数据
    X <- list(
      c(0.8, 0, 0.9),
      c(0, 0.7),
      c(0.6, 0, 0.8),
      c(0.8),
      c(0.7, 0, 0.9),
      c(0, 0.7),
      c(0.6, 0, 0.8),
      c(0.8),
      c(0, 0.7),
      c(0.7, 0, 0.9),
      c(0.8, 0, 0.9),
      c(0, 0.7),
      c(0.6, 0, 0.8),
      c(0.8),
      c(0.7, 0, 0.9),
      c(0, 0.7),
      c(0.6, 0, 0.8),
      c(0.8),
      c(0, 0.7),
      c(0.7, 0, 0.9)
    )  # 每个阳性病例的置信分数
    n1 <- c(2, 0, 2, 0, 2, 0, 2, 0, 0, 2, 2, 0, 2, 0, 2, 0, 2, 0, 0, 2)  # 每个阳性病例的错误定位数，多取一些为0
    Y1 <- list(
      c(0.5, 0.6),
      numeric(0),
      c(0.4, 0.5),
      numeric(0),
      c(0.5, 0.6),
      numeric(0),
      c(0.4, 0.5),
      numeric(0),
      numeric(0),
      c(0.5, 0.6),
      c(0.5, 0.6),
      numeric(0),
      c(0.4, 0.5),
      numeric(0),
      c(0.5, 0.6),
      numeric(0),
      c(0.4, 0.5),
      numeric(0),
      numeric(0),
      c(0.5, 0.6)
    )  # 每个阳性病例的错误定位置信分数
    n0 <- c(2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2)  # 每个阴性病例的错误定位数
    Y0 <- list(
      c(0.3, 0.4),
      c(0.3),
      c(0.3, 0.4),
      c(0.3),
      c(0.3, 0.4),
      c(0.3),
      c(0.3, 0.4),
      c(0.3),
      c(0.3),
      c(0.3, 0.4),
      c(0.3, 0.4),
      c(0.3),
      c(0.3, 0.4),
      c(0.3),
      c(0.3, 0.4),
      c(0.3),
      c(0.3, 0.4),
      c(0.3),
      c(0.3),
      c(0.3, 0.4)
    )
    
    # 调用AFROC 计算函数
    result <- calculate_and_plot_AFROC_with_AAF(t, L, X, n1, Y1, n0, Y0)
    
    # 输出结果
    output$afroc_result <- renderPrint({
      cat("AAF:", result$AAF, "\n")
      cat("LLFA values:", paste(result$LLFA, collapse = ", "), "\n")
      cat("FPFA values:", paste(result$FPFA, collapse = ", "), "\n")
    })
    
    # 绘图输出
    output$afroc_plot <- renderPlot({
      ggplot(data.frame(FPFA = result$FPFA, LLFA = result$LLFA), aes(x = FPFA, y = LLFA)) +
        geom_line() +
        geom_point() +
        labs(title = "AFROC 曲线", x = "FPFA(ζ)", y = "LLFA(ζ)") +
        xlim(0, 1) +
        ylim(0, 1) +
        theme_minimal()
    })
    
    # 显示默认数据
    output$default_afroc_data_display <- renderPrint({
      cat("默认数据示例：\n")
      cat("t <- c(", paste(t, collapse = ", "), ")\n")
      cat("L <- list(", paste(sapply(L, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
      cat("X <- list(", paste(sapply(X, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
      cat("n1 <- c(", paste(n1, collapse = ", "), ")\n")
      cat("Y1 <- list(", paste(sapply(Y1, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
      cat("n0 <- c(", paste(n0, collapse = ", "), ")\n")
      cat("Y0 <- list(", paste(sapply(Y0, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
    })
  })
}













resampling_server <- function(input, output, session) {
  
    observeEvent(input$run_resampling, {
    req(input$resampling_csv_input || input$resampling_excel_input)
    
    if (!is.null(input$resampling_csv_input)) {
      data <- read_csv(input$resampling_csv_input$datapath)
    } else if (!is.null(input$resampling_excel_input)) {
      data <- read_excel(input$resampling_excel_input$datapath)
    }
    
    # 预处理数据
    processed_data <- preprocess_data(data)
    
    # 提取数据
    t <- processed_data$t
    L <- processed_data$L
    X <- processed_data$X
    n1 <- processed_data$n1
    Y1 <- processed_data$Y1
    n0 <- processed_data$n0
    Y0 <- processed_data$Y0
    
    result <- calculate_FAUC_with_SD(t, L, X, n1, Y1, n0, Y0, p = input$bootstrap_samples)
    
    output$resampling_results <- renderPrint({
      cat("FAUC:", result$FAUC, "\n")
      cat("Jackknife FAUC 标准差:", result$jackknife_FAUC_sd, "\n")
      cat("Bootstrap FAUC 标准差:", result$bootstrap_FAUC_sd, "\n")
    
    })
    
    })
  
  observeEvent(input$default_resampling, {
        t <- c(5, 4, 6, 3, 7)  # 阳性病例的病灶个数
        L <- list(
          c(1, 0, 1, 1, 0),
          c(0, 1, 1, 0),
          c(1, 0, 1, 1, 0, 1),
          c(1, 0, 1),
          c(1, 0, 1, 1, 0, 1, 1)
        )  # 每个阳性病例的病灶数据
        X <- list(
          c(0.8, 0, 0.9, 0.7, 0),
          c(0, 0.7, 0.8, 0),
          c(0.6, 0, 0.8, 0.9, 0, 0.7),
          c(0.8, 0, 0.9),
          c(0.7, 0, 0.8, 0.9, 0, 0.7, 0.8)
        )   # 每个阳性病例的置信分数
        n1 <- c(3, 2, 4, 1, 5)  # 每个阳性病例的错误定位数
        Y1 <- list(
          c(0.5, 0.6, 0.7),
          c(0.7, 0.8),
          c(0.4, 0.5, 0.6, 0.7),
          c(0.8),
          c(0.5, 0.6, 0.7, 0.8, 0.9)
        )  # 每个阳性病例的错误定位置信分数
        n0 <- c(2, 3, 1, 2, 4)  # 每个阴性病例的错误定位数
        Y0 <- list(
          c(0.3, 0.4),
          c(0.4, 0.5, 0.6),
          c(0.3),
          c(0.4, 0.5),
          c(0.3, 0.4, 0.5, 0.6)
        )  # 每个阴性病例的错误定位置信分数
    
        result <- calculate_FAUC_with_SD(t, L, X, n1, Y1, n0, Y0, p = 1000)
 
            # 输出结果
        output$resampling_results <- renderPrint({
          cat("FAUC:", result$FAUC, "\n")
          cat("Jackknife FAUC 标准差:", result$jackknife_FAUC_sd, "\n")
          cat("Bootstrap FAUC 标准差:", result$bootstrap_FAUC_sd, "\n")
                  })
    
    
    # 显示默认数据
    output$default_resampling_data_display <- renderPrint({
      cat("默认数据示例：\n")
      cat("t <- c(", paste(t, collapse = ", "), ")\n")
      cat("L <- list(", paste(sapply(L, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
      cat("X <- list(", paste(sapply(X, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
      cat("n1 <- c(", paste(n1, collapse = ", "), ")\n")
      cat("Y1 <- list(", paste(sapply(Y1, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
      cat("n0 <- c(", paste(n0, collapse = ", "), ")\n")
      cat("Y0 <- list(", paste(sapply(Y0, function(x) paste0("c(", paste(x, collapse = ", "), ")")), collapse = ", "), ")\n")
    })
  })
  
  
  
    }
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  




 