library(shiny)

# 加载模块
source("12.3_ui_modules.R")
source("12.3_server_modules.R")
source("12.3_ui_modules.R")
source("12.3_server_modules.R")
source("12.3_utils.R")

# 定义主UI
ui <- navbarPage("FROC 计算应用",
                 froc_ui,  # FROC子页面
                 iroc_ui,    # Inferred ROC分析子页面
                 afroc_ui,    #afroc分析子页面
                 resampling_ui #bootstrap计算AUC sd子页面
)

# 定义主Server
server <- function(input, output, session) {
  froc_server(input, output, session)  # FROC Server逻辑
  iroc_server(input, output, session)  # Inferred ROC Server逻辑
  afroc_server(input, output, session) # AFROC Server逻辑
  resampling_server(input,output,session) #resampling逻辑
}

# 运行Shiny应用
shinyApp(ui = ui, server = server)



