#' Title truedisease
#'
#' @param para A 9-dimensional vector
#' @param observedk The observation of the i th individual,is a 2-dimensional vector
#' @param measurek summary measure,a number that follows a standard normal distribution
#'
#' @return Probability parameter of binomial distribution
#' @export
#'
#'
truedisease <- function(para, observedk, measurek){
  pi <- para[1]
  a10 <- para[2]
  b10 <- para[3]
  a11 <- para[4]
  b11 <- para[5]
  a20 <- para[6]
  b20 <- para[7]
  a21 <- para[8]
  b21 <- para[9]
  t1 <- observedk[1]
  t2 <- observedk[2]
  index1 <- pi * ((pnorm(a11+b11*measurek))^t1) * ((1-(pnorm(a11+b11*measurek)))^(1-t1)) *
    ((pnorm(a21+b21*measurek))^t2) * ((1-(pnorm(a21+b21*measurek)))^(1-t2))
  index0 <- (1-pi) * ((pnorm(a10+b10*measurek))^t1) * ((1-(pnorm(a10+b10*measurek)))^(1-t1)) *
    ((pnorm(a20+b20*measurek))^t2) * ((1-(pnorm(a20+b20*measurek)))^(1-t2))
  p <- index1/(index1+index0)
  return(p)
}


#' Title mh_a10b10
#'
#' @param a10 Parameter values of the last iteration
#' @param b10 Parameter values of the last iteration
#' @param observedall All the observations
#' @param truestatusall All true values
#' @param rall All random effects parameters
#' @param mua10 Prior information
#' @param sigmaa10 Prior information
#' @param mub10 Prior information
#' @param sigmab10 Prior information
#'
#' @return The value of the next iteration
#' @export
#'
#'
MH_a10b10 <- function(a10, b10, observedall, truestatusall, rall, mua10, sigmaa10, mub10, sigmab10){
  a10_1 <- rnorm(1, a10, 2)
  b10_1 <- rnorm(1, b10, 2)
  N <- length(rall)
  ratio1 <- rep(0,N)
  li <- rep(0, N)
  for (i in 1:N){
    li <- ((pnorm(a10+b10*rall[i]))^((1-truestatusall[i])*observedall[i,1])) *
      ((1-(pnorm(a10+b10*rall[i])))^((1-truestatusall[i])*(1-observedall[i,1])))
    li_1 <- ((pnorm(a10_1+b10_1*rall[i]))^((1-truestatusall[i])*observedall[i,1])) *
      ((1-(pnorm(a10_1+b10_1*rall[i])))^((1-truestatusall[i])*(1-observedall[i,1])))
    ratio1[i] <- li_1/li
  }
  pa <- pnorm(a10, mua10, sigmaa10)
  pa_1 <- pnorm(a10_1, mua10, sigmaa10)
  ratio2 <- pa_1/pa

  pb <- pnorm(b10, mub10, sigmab10)
  pb_1 <- pnorm(b10_1, mub10, sigmab10)
  ratio3 <- pb_1/pb

  r <- prod(ratio1)*ratio2*ratio3

  u <- runif(1)

  if(r>u){
    a10_new <- a10_1
    b10_new <- b10_1
  }else{
    a10_new <- a10
    b10_new <- b10
  }
  return(c(a10_new,b10_new))
}


#' Title mh_a20b20
#'
#' @param a20 Parameter values of the last iteration
#' @param b20 Parameter values of the last iteration
#' @param observedall All the observations
#' @param truestatusall All true values
#' @param rall All random effects parameters
#' @param mua20 Prior information
#' @param sigmaa20 Prior information
#' @param mub20 Prior information
#' @param sigmab20 Prior information
#'
#' @return The value of the next iteration
#' @export
#'
#'
MH_a20b20 <- function(a20, b20, observedall, truestatusall, rall, mua20, sigmaa20, mub20, sigmab20){
  a20_1 <- rnorm(1, a20, 2)
  b20_1 <- rnorm(1, b20, 2)

  N <- length(rall)
  ratio1 <- rep(0,N)
  li <- rep(0, N)
  for (i in 1:N){
    li <- ((pnorm(a20+b20*rall[i]))^((1-truestatusall[i])*observedall[i,2])) *
      ((1-(pnorm(a20+b20*rall[i])))^((1-truestatusall[i])*(1-observedall[i,2])))
    li_1 <- ((pnorm(a20_1+b20_1*rall[i]))^((1-truestatusall[i])*observedall[i,2])) *
      ((1-(pnorm(a20_1+b20_1*rall[i])))^((1-truestatusall[i])*(1-observedall[i,2])))
    ratio1[i] <- li_1/li
  }
  pa <- pnorm(a20, mua20, sigmaa20)
  pa_1 <- pnorm(a20_1, mua20, sigmaa20)
  ratio2 <- pa_1/pa

  pb <- pnorm(b20, mub20, sigmab20)
  pb_1 <- pnorm(b20_1, mub20, sigmab20)
  ratio3 <- pb_1/pb

  r <- prod(ratio1)*ratio2*ratio3

  u <- runif(1)

  if(r>u){
    a20_new <- a20_1
    b20_new <- b20_1
  }else{
    a20_new <- a20
    b20_new <- b20
  }
  return(c(a20_new,b20_new))
}




#' Title mh_a11b11
#'
#' @param a11 Parameter values of the last iteration
#' @param b11 Parameter values of the last iteration
#' @param observedall All the observations
#' @param truestatusall All true values
#' @param rall All random effects parameters
#' @param mua11 Prior information
#' @param sigmaa11 Prior information
#' @param mub11 Prior information
#' @param sigmab11 Prior information
#'
#' @return The value of the next iteration
#' @export
#'
#'
MH_a11b11 <- function(a11, b11, observedall, truestatusall, rall, mua11, sigmaa11, mub11, sigmab11){
  a11_1 <- rnorm(1, a11, 2)
  b11_1 <- rnorm(1, b11, 2)

  N <- length(rall)
  ratio1 <- rep(0,N)
  li <- rep(0, N)
  for (i in 1:N){
    li <- ((pnorm(a11+b11*rall[i]))^(truestatusall[i]*observedall[i,1])) *
      ((1-(pnorm(a11+b11*rall[i])))^(truestatusall[i]*(1-observedall[i,1])))
    li_1 <- ((pnorm(a11_1+b11_1*rall[i]))^(truestatusall[i]*observedall[i,1])) *
      ((1-(pnorm(a11_1+b11_1*rall[i])))^(truestatusall[i]*(1-observedall[i,1])))
    ratio1[i] <- li_1/li
  }
  pa <- pnorm(a11, mua11, sigmaa11)
  pa_1 <- pnorm(a11_1, mua11, sigmaa11)
  ratio2 <- pa_1/pa

  pb <- pnorm(b11, mub11, sigmab11)
  pb_1 <- pnorm(b11_1, mub11, sigmab11)
  ratio3 <- pb_1/pb

  r <- prod(ratio1)*ratio2*ratio3

  u <- runif(1)

  if(r>u){
    a11_new <- a11_1
    b11_new <- b11_1
  }else{
    a11_new <- a11
    b11_new <- b11
  }
  return(c(a11_new,b11_new))
}






#' Title mh_a21b21
#'
#' @param a21 Parameter values of the last iteration
#' @param b21 Parameter values of the last iteration
#' @param observedall All the observations
#' @param truestatusall All true values
#' @param rall All random effects parameters
#' @param mua21 Prior information
#' @param sigmaa21 Prior information
#' @param mub21 Prior information
#' @param sigmab21 Prior information
#'
#' @return The value of the next iteration
#' @export
#'
#'
MH_a21b21 <- function(a21, b21, observedall, truestatusall, rall, mua21, sigmaa21, mub21, sigmab21){
  a21_1 <- rnorm(1, a21, 2)
  b21_1 <- rnorm(1, b21, 2)

  N <- length(rall)
  ratio1 <- rep(0,N)
  li <- rep(0, N)
  for (i in 1:N){
    li <- ((pnorm(a21+b21*rall[i]))^(truestatusall[i]*observedall[i,2])) *
      ((1-(pnorm(a21+b21*rall[i])))^(truestatusall[i]*(1-observedall[i,2])))
    li_1 <- ((pnorm(a21_1+b21_1*rall[i]))^(truestatusall[i]*observedall[i,2])) *
      ((1-(pnorm(a21_1+b21_1*rall[i])))^(truestatusall[i]*(1-observedall[i,2])))
    ratio1[i] <- li_1/li
  }
  pa <- pnorm(a21, mua21, sigmaa21)
  pa_1 <- pnorm(a21_1, mua21, sigmaa21)
  ratio2 <- pa_1/pa

  pb <- pnorm(b21, mub21, sigmab21)
  pb_1 <- pnorm(b21_1, mub21, sigmab21)
  ratio3 <- pb_1/pb

  r <- prod(ratio1)*ratio2*ratio3

  u <- runif(1)

  if(r>u){
    a21_new <- a21_1
    b21_new <- b21_1
  }else{
    a21_new <- a21
    b21_new <- b21
  }
  return(c(a21_new,b21_new))
}



Lik_r <- function(r, t1, t2, a10, b10, a20, b20, a11, b11, a21, b21, d){
  li <- ((pnorm(a11+b11*r))^(d*t1)) *
    ((1-(pnorm(a11+b11*r)))^(d*(1-t1))) *
    ((pnorm(a21+b21*r))^(d*t2)) *
    ((1-(pnorm(a21+b21*r)))^(d*(1-t2))) *
    ((pnorm(a10+b10*r))^((1-d)*(t1))) *
    ((1-(pnorm(a10+b10*r)))^((1-d)*(1-t1))) *
    ((pnorm(a20+b20*r))^((1-d)*(t2))) *
    ((1-(pnorm(a20+b20*r)))^((1-d)*(1-t2))) *
    dnorm(r)
  return(li)
}



SIR_r <- function(t1, t2, a10, b10, a20, b20, a11, b11, a21, b21, d, m){
  li <- rep(0, m)
  g <- rep(0, m)
  weight <- rep(0,m)

  while (sum(weight)==0){
    sample1 <- rnorm(m, 0, 1)
    for (i in 1:m){
      li[i] <- Lik_r(sample1[i], t1, t2, a10, b10, a20, b20, a11, b11, a21, b21, d)
      g[i] <- dnorm(sample1[i], 0, 1)
      weight[i] <- li[i]/g[i]
    }
  }
  weight <- weight/sum(weight)
  r <- sample(sample1, 1, prob=weight)
  return(r)
}






#' Title randomeffect_2_1
#'
#' @param api Hyperparameters of the prior distribution of prevalence
#' @param bpi Hyperparameters of the prior distribution of prevalence
#' @param prior The mean and variance of the prior normal distribution of the remaining eight parameters to be estimated are 8*2-dimensional matrices
#' @param observe The observed 2-by-2-dimensional matrix
#' @param n The number of cycles, that is, how many groups of data are sampled
#' @param burn burn_in period,the number of data discarded earlier
#'
#' @return Means and 95% confidence intervals for prevalence, sensitivity and specificity
#' @export
#'
#' @examples
#' data_2001=matrix(c(38,2,87,35),nrow=2,byrow=TRUE)
#' prior_2001 <- matrix(c(2.171, 0.261,
#' 0.861, 0.5,
#' -0.811, 0.380,
#' 0.668, 0.5,
#' 0.692, 0.560,
#' 0.861, 0.5,
#' 1.012, 0.268,
#' 0.668, 0.5), ncol=2, byrow=TRUE)
#' randomeffect_2_1(1,1,prior_2001,data_2001,10500,500)
randomeffect_2_1 <- function(api,bpi,prior,observe,n,burn){
  X <- matrix(0, n, 9)
  X[1, 1] <- rbeta(1,api,bpi)
  X[1, 2] <- rnorm(1, prior[1,1], prior[1,2])
  X[1, 3] <- rnorm(1, prior[2,1], prior[2,2])
  X[1, 4] <- rnorm(1, prior[3,1], prior[3,2])
  X[1, 5] <- rnorm(1, prior[4,1], prior[4,2])
  X[1, 6] <- rnorm(1, prior[5,1], prior[5,2])
  X[1, 7] <- rnorm(1, prior[6,1], prior[6,2])
  X[1, 8] <- rnorm(1, prior[7,1], prior[7,2])
  X[1, 9] <- rnorm(1, prior[8,1], prior[8,2])

  n_11 <- observe[1,1]
  n_10 <- observe[1,2]
  n_01 <- observe[2,1]
  n_00 <- observe[2,2]
  N <- n_11+n_10+n_01+n_00

  rf <- rnorm(N)

  result <- matrix(0, nrow = N, ncol = 2)
  result[1:(n_11+n_10), 1] <- 1
  result[1:n_11, 2] <- 1
  result[(n_11+n_10+1):(n_11+n_10+n_01), 2] <- 1


  for (i in 2:n){

    pi_0 <- X[i-1, 1]
    a10_0 <- X[i-1, 2]
    b10_0 <- X[i-1, 3]
    a11_0 <- X[i-1, 4]
    b11_0 <- X[i-1, 5]
    a20_0 <- X[i-1, 6]
    b20_0 <- X[i-1, 7]
    a21_0 <- X[i-1, 8]
    b21_0 <- X[i-1, 9]
    truestatus <- rep(0, N)

    for (j in 1:N){
      truestatus[j] <- rbinom(1, 1, truedisease(X[i-1,], result[j,], rf[j]))
    }

    X[i, 1] <- rbeta(1, api+sum(truestatus), bpi+N-sum(truestatus))

    para10 <- MH_a10b10(a10_0, b10_0, result, truestatus, rf,
                        prior[1,1], prior[1,2], prior[2,1], prior[2,2])

    X[i, 2] <- para10[1]
    X[i, 3] <- para10[2]

    para11 <- MH_a11b11(a11_0, b11_0, result, truestatus, rf,
                        prior[3,1], prior[3,2], prior[4,1], prior[4,2])

    X[i, 4] <- para11[1]
    X[i, 5] <- para11[2]

    para20 <- MH_a20b20(a20_0, b20_0, result, truestatus, rf,
                        prior[5,1], prior[5,2], prior[6,1], prior[6,2])

    X[i, 6] <- para20[1]
    X[i, 7] <- para20[2]

    para21 <- MH_a21b21(a21_0, b21_0, result, truestatus, rf,
                        prior[7,1], prior[7,2], prior[8,1], prior[8,2])

    X[i, 8] <- para21[1]
    X[i, 9] <- para21[2]

    for (j in 1:N){
      rf[j] <- SIR_r(result[j,1], result[j,2], X[i,2], X[i,3], X[i,6], X[i,7], X[i,4], X[i,5], X[i,8], X[i,9], truestatus[j], 300)
    }
    cat(i,"completed\n")
  }
  b <- burn + 1
  oringin <- X[b:n, ]
  colnames(oringin) <- c("pi", "a10", "b10", "a11", "b11", "a20", "b20","a21","b21")

  a10=oringin[,2]
  b10=oringin[,3]
  a11=oringin[,4]
  b11=oringin[,5]
  a20=oringin[,6]
  b20=oringin[,7]
  a21=oringin[,8]
  b21=oringin[,9]

  trace <- matrix(0, n-burn, 5)
  colnames(trace)<-c("pi", "sens1", "spec1", "sens2", "spec2")
  trace[,1]<-oringin[,1]
  trace[,2]<-pnorm(a11 / sqrt(1 + b11^2))
  trace[,3]<-pnorm((a10 / sqrt(1 + b10^2)))
  trace[,4]<-pnorm(a21 / sqrt(1 + b21^2))
  trace[,5]<-pnorm((a20 / sqrt(1 + b20^2)))

  result <- list()
  for(j in 1:5){
    result[[colnames(trace)[j]]] <- c(median(trace[, j]),
                                      quantile(trace[, j], c(0.025, 0.975)))
  }

  return(result)
}
