% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11.3（without cia）.R
\name{gibbs_sampler}
\alias{gibbs_sampler}
\title{Title 11.3(without_cia)}
\usage{
gibbs_sampler(
  init_pi,
  init_sens1,
  init_spec1,
  init_sens2,
  init_spec2,
  init_covc12,
  init_covs12,
  data,
  n_iter,
  burn_in,
  alpha.pi,
  beta.pi,
  alpha.sens1,
  beta.sens1,
  alpha.spec1,
  beta.spec1,
  alpha.sens2,
  beta.sens2,
  alpha.spec2,
  beta.spec2,
  alpha.covs12,
  beta.covs12,
  alpha.covc12,
  beta.covc12
)
}
\arguments{
\item{init_pi}{Initial value of prevalence}

\item{init_sens1}{Initial value of sensitivity}

\item{init_spec1}{Initial value of specificity}

\item{init_sens2}{Initial value of sensitivity}

\item{init_spec2}{Initial value of specificity}

\item{init_covc12}{The initial value of the covariance parameter}

\item{init_covs12}{The initial value of the covariance parameter}

\item{data}{Observations, a four-dimensional vector}

\item{n_iter}{Number of iterations}

\item{burn_in}{burn_in period}

\item{alpha.pi}{Prior information on prevalence}

\item{beta.pi}{Prior information on prevalence}

\item{alpha.sens1}{Prior information on sensitivity}

\item{beta.sens1}{Prior information on sensitivity}

\item{alpha.spec1}{Prior information on specificity}

\item{beta.spec1}{Prior information on specificity}

\item{alpha.sens2}{Prior information on sensitivity}

\item{beta.sens2}{Prior information on sensitivity}

\item{alpha.spec2}{Prior information on specificity}

\item{beta.spec2}{Prior information on specificity}

\item{alpha.covs12}{Prior information on covariance parameters}

\item{beta.covs12}{Prior information on covariance parameters}

\item{alpha.covc12}{Prior information on covariance parameters}

\item{beta.covc12}{Prior information on covariance parameters}
}
\value{
Means and 95\% confidence intervals for prevalence, sensitivity and specificity
}
\description{
Title 11.3(without_cia)
}
\examples{
gibbs_sampler(init_pi=0.5, init_sens1=0.95, init_spec1=0.97, init_sens2=0.9, init_spec2=0.95, init_covc12=0.5, init_covs12=0.5, data=c(38,2,87,35), n_iter=2000, burn_in=500, alpha.pi = 1, beta.pi = 1, alpha.sens1 = 4.44,beta.sens1 = 13.31, alpha.spec1 = 71.25, beta.spec1 = 3.75,alpha.sens2 = 21.96, beta.sens2 = 5.49, alpha.spec2 = 4.1,beta.spec2 = 1.76, alpha.covs12 = 1, beta.covs12 = 1, alpha.covc12 = 1,beta.covc12 = 1)
}
