



#'  Correction Methods Under the MAR Assumption with a Continuous-Scale Test
#'
#' @param N (s, r, u), where s means number of subjects verified with the disease conditions, r means number of subjects verified without the disease conditions, u means number of subjects without being verified.
#' @param c Threshold points for classification
#'
#' @return Se_FI, Sp_FI, Se_MSI, Sp_MSI
#' @importFrom stats nlminb
#' @export
#'
#'
#'
Correct_Bias_6 <- function(N, c){
  ##本函数使用模拟随机生成的数据集进行试验，模拟效果目前不太理想，编译部分无问题
  ##分类V = 1和V = 0两类数据
  selectV1 <- function(X){
    n <- ncol(X)
    l <- length(X) %/% n
    X1 <- X[X[ , 1] == 1]

    X1 <- array(X1, dim = c(l, n))
    return <- X1
  }

  selectV2 <- function(X){
    K <- nrow(X)
    X2 <- X[X[ , 1] == 0]
    return <- X2
  }

  ##rho 的逻辑斯蒂建模
  rho <- function(beta, N){
    L <- length(N)
    N1 <- array(0, dim = c(L))
    N1[2:L] <- N[2:L]
    N1[1] <- 1
    return <- exp(sum(beta * N1)) / (1 + exp(sum(beta * N1)))
  }
  ##pi的逻辑斯蒂建模，其中x各项含义为(V, D, T, X),其中D项无意义，V项为0
  pi <- function(alpha, N){
    return <- exp(sum(alpha * N)) / (1 + exp(sum(alpha * N)))
  }
  ##rho的最大似然
  ML1 <- function(beta, N){
    K <- nrow(N)
    sum <- 0
    for(k in 1:K){
      if(N[k, 1] == 1){
        sum <- sum + log(rho(beta, N[k, ]))
      }
      if(N[k, 1] == 0){
        sum <- sum + log(1 - rho(beta, N[k, ]))
      }
      if(N[k, 1] != 1 & N[k, 1] != 0){
        sum <- sum - 1e7
      }
    }
    return <- -sum
  }
  ##pi的最大似然
  ML2 <- function(alpha, N){
    K <- nrow(N)
    sum <- 0
    for(k in 1:K){
      sum <- sum + pi(alpha, N[k, ])
    }
    return <- -sum
  }
  n <- nrow(N)
  C <- ncol(N)
  K <- C - 3
  N1 <- selectV1(N)
  beta0 <- array(c(1, 1, 0.5), dim = c(K + 2))
  alpha0 <- array(0, dim = c(K + 2))
  ##计算rho, pi估计值
  N2 <- N1[, 2: C]
  n2 <- nrow(N2)
  orse1 <- nlminb(beta0, ML1, N = N2)
  beta <- orse1$par
  N3 <- N[, 2: C]
  ##计算FI估计值
  sum1 <- 0
  sum2 <- 0
  sum3 <- 0
  sum4 <- 0
  for(i in 1:n){
    if(N[i, 3] >= c){
      sum1 <- sum1 + rho(beta, N3[i, ])
    }
    else{
      sum3 <- sum3 + 1 - rho(beta, N3[i, ])
    }
    sum2 <- sum2 + rho(beta, N3[i, ])
    sum4 <- sum4 + 1 - rho(beta, N3[i, ])
  }
  Se_FI <- sum1 / sum2
  Sp_FI <- sum3 / sum4

  ##计算MSI估计值
  sum1 <- 0
  sum2 <- 0
  sum3 <- 0
  for (i in 1:n){
    if(N[i, 3] >= c){
      sum1 <- sum1 + (N[i, 1] * N[i, 2] + (1 - N[i, 1]) * rho(beta, N3[i, ]))
    }
    else{
      sum3 <- sum3 + (N[i, 1] * (1 - N[i, 2]) + (1 - N[i, 1]) * (1 - rho(beta, N3[i, ])))
    }
    sum2 <- sum2 + (N[i, 1] * N[i, 2] + (1 - N[i, 1]) * rho(beta, N3[i, ]))
    sum4 <- sum4 + (N[i, 1] * (1 - N[i, 2]) + (1 - N[i, 1]) * (1 - rho(beta, N3[i, ])))
  }
  Se_MSI <- sum1 / sum2
  Sp_MSI <- sum3 / sum4

  return <- list(Se_FI, Sp_FI, Se_MSI, Sp_MSI)
}

