

#' Correction Methods Under the MAR Assumption with Two relative Binary-Scale Test Without Any Covariates
#'
#' @param N (s, r, u), where s means number of subjects verified with the disease conditions, r means number of subjects verified without the disease conditions, u means number of subjects without being verified.
#'
#' @return Se_hat_1, Se_hat_2, Sp_hat_1, Sp_hat_2
#' @export
#'
Correct_Bias_2 <- function(N){
  s <- N[, , 1]
  r <- N[, , 2]
  m <- N[, , 3]

  x <- array(0, dim = c(2, 2))
  y <- array(0, dim = c(2, 2))
  for(i in 1:2){
    for(j in 1:2){
      x[i, j] <- s[i, j] * m[i, j] / (s[i, j] + r[i, j])
      y[i, j] <- r[i, j] * m[i, j] / (s[i, j] + r[i, j])
    }
  }
  Se_hat_1 <- (x[2, 1] + x[2, 2])/(sum(x))
  Se_hat_2 <- (x[1, 2] + x[2, 2])/(sum(x))
  Sp_hat_1 <- (y[1, 1] + y[1, 2])/(sum(y))
  Sp_hat_2 <- (y[1, 1] + y[2, 1])/(sum(y))

  return(list(Se_hat_1, Se_hat_2, Sp_hat_1, Sp_hat_2))

}
