

#' Correction Methods Under the MAR Assumption with a Single Ordinal-Scale Test and Estimate it's Empirical ROC curve
#'
#' @param N (s, r, u), where s means number of subjects verified with the disease conditions, r means number of subjects verified without the disease conditions, u means number of subjects without being verified.
#'
#' @return TPR, FPR, eA
#' @export
#'
Correct_Bias_4e <- function(N){
  s <- N[, 1]
  r <- N[, 2]
  u <- N[, 3]
  m <- s + r + u
  K <- length(m)

  n <- 0
  for(i in 1:K){
    n <- n + m[i]
  }
  phi1 <- array(0, dim = c(K))
  phi2 <- array(0, dim = c(K))

  for(i in 1:K){
    phi1[i] <- m[i] / n
    phi2[i] <- s[i] / (s[i] + r[i])
  }

  TPR <- array(0, dim = c(K))
  FPR <- array(0, dim = c(K))
  sum1 <- 0
  sum2 <- 0
  for(i in 1:K){
    sum1 <- sum1 + phi1[i] * phi2[i]
    sum2 <- sum2 + phi1[i] * (1 - phi2[i])
  }

  for(i in 1:K){
    sum3 <- 0
    sum4 <- 0
    for(j in i:K){
      sum3 <- sum3 + phi1[j] * phi2[j]
      sum4 <- sum4 + phi1[j] * (1 - phi2[j])
    }
    TPR[i] <- sum3 / sum1
    FPR[i] <- sum4 / sum2
  }

  ##计算经验ROC曲线下的面积
  eA <- 0
  for(i in 1:(K - 1)){
    eA <- eA + (FPR[i] - FPR[i + 1]) * (TPR[i] + TPR[i + 1]) * 0.5
  }
  eA <- eA + 0.5 * FPR[K] * TPR[K]

  plot(FPR, TPR, type = "l")
  return <- list(TPR, FPR, eA)
}
