
#' Correction Methods Under the MAR Assumption with Two relative Binary-Scale Test With Covariates
#'
#' @param r number of subjects verified without the disease conditions
#' @param s number of subjects verified with the disease conditions
#' @param n number of subjects with same test result
#' @param X covariates in subjects
#'
#' @return Se_hat, Sp_hat
#' @import stats
#'
#' @importFrom stats nlminb
#'
#' @export
#'

Correct_Bias_3 <- function(r, s, n, X){
  ##beta及phi对应的似然函数
  objf.norm1 <- function(beta, N, X){
    G = ncol(X)
    K = nrow(X)
    L = length(beta)
    beta_0 <- beta[1:3]
    beta_1 <- beta[4:L]
    phi <- array(0, dim = c(2, 2, G))
    Sum <- array(0,c(2, 2, G))
    SUM <- 0
    for(i in 0:1){
      for(j in 0:1){
        for(g in 1:G){
          Sum[i + 1, j + 1, g] <- exp(beta_0[1] + beta_0[2] * i + beta_0[3] * j + sum(beta_1 * X[ , g]))
          phi[i + 1,j + 1,g] <- Sum[i + 1, j + 1, g] / (1 + Sum[i + 1, j + 1, g])
          SUM <- SUM + N[i + 1, j + 1, g, 1] * log(phi[i + 1, j + 1, g]) + N[i + 1, j + 1, g, 2] * log(1 - phi[i + 1, j + 1, g])
        }
      }
    }
    return <- -SUM

  }


  ##alpha以及eta对应的似然函数
  objf.norm2 <- function(alpha, n, X){
    G = ncol(X)
    K = nrow(X)
    L = length(alpha)
    alpha_0 <- array(alpha[1:3], dim = c(2, 2))
    alpha_1 <- array(alpha[4: L], dim = c(2, 2, K))
    alpha_0[2, 2] <- 0
    alpha_1[2, 2, ] <- 0
    eta <- array(0, dim = c(2, 2, G))
    SUM <- array(0, G)
    SUM2 <- 0
    Sum <- array(0, dim = c(2, 2, G))
    ##计算eta
    for (i in 0:1){
      for(j in 0:1){
        for(g in 1:G){
          Sum[i + 1, j + 1, g] <- exp(alpha_0[i + 1, j + 1] + sum(alpha_1[i + 1, j + 1, ] * X[ , g]))
          SUM[g] <- SUM[g] + Sum[i + 1, j + 1, g]
        }
      }
    }
    for (i in 0:1){
      for(j in 0:1){
        for(g in 1:G){
          eta[i + 1, j + 1, g] <- Sum[i + 1, j + 1, g] /SUM[g]
        }
      }
    }
    for (i in 0:1){
      for(j in 0:1){
        for(g in 1:G){
          SUM2 <- SUM2 + n[i + 1, j + 1, g] * log(eta[i + 1, j + 1, g])
        }
      }
    }

    return <- -SUM2
  }

  G = ncol(X)
  K = nrow(X)
  N1 <- array(0, dim = c(G))
  ##估计kexi的值
  Kexi_hat <- array(0, dim = c(G))
  for(g in 1:G){
    for(i in 0:1){
      for(j in 0:1){
        N1[g] <- N1[g] + n[i + 1, j + 1, g]
      }
    }
  }
  M <- sum(N1)
  for(g in 1:G){
    Kexi_hat[g] <- N1[g] / M
  }
  ##设定初始值
  alpha_0 <- array(c(2.55, 0.4429, -0.5402, 0.9103, 0.3337, 0.772), dim = c(3 + 3 * K))
  beta_0 <- array(5, dim = c(3 + K))
  ##使用MLE估计alpha以及eta
  N <- array(c(s, r, n), dim = c(2, 2, 2, 3))
  ores2 <- nlminb(alpha_0, objf.norm2, n = n, X = X)
  ores1 <- nlminb(beta_0, objf.norm1, N = N, X = X)

  alpha <- ores2$par
  beta <- ores1$par
  ##计算eta_hat
  L = length(alpha)
  alpha_0 <- array(alpha[1:3], dim = c(2, 2))
  alpha_1 <- array(alpha[4: L], dim = c(2, 2, K))
  alpha_0[2, 2] <- 0
  alpha_1[2, 2, ] <- 0
  eta_hat <- array(0, dim = c(2, 2, G))
  Sum <- array(0, dim = c(2, 2, G))
  SUM <- array(0, G)
  for (i in 0:1){
    for(j in 0:1){
      for(g in 1:G){
        Sum[i + 1, j + 1, g] <- exp(alpha_0[i+1, j+1] + sum(alpha_1[i+1, j+1, ] * X[ , g]))
        SUM[g] <- SUM[g] + Sum[i + 1, j + 1, g]
      }
    }
  }
  for (i in 0:1){
    for(j in 0:1){
      for(g in 1:G){
        eta_hat[i + 1, j + 1, g] <- Sum[i + 1, j + 1, g] /SUM[g]
      }
    }
  }

  ##计算phi_hat
  L = length(beta)
  beta_0 <- beta[1:3]
  beta_1 <- beta[4:L]
  phi_hat <- array(0, dim = c(2, 2, G))
  Sum <- array(0,dim = c(2, 2, G))
  for(i in 0:1){
    for(j in 0:1){
      for(g in 1:G){
        Sum[i + 1, j + 1, g] <- exp(beta_0[1] + beta_0[2] * i + beta_0[3] * j + sum(beta_1 * X[ , g]))
        phi_hat[i + 1,j + 1,g] <- Sum[i+1, j +1, g] / (1 + Sum[i + 1, j + 1, g])
      }
    }
  }

  ##估计Se和Sp
  p <- 0
  P <- array(0, dim = c(4))
  for(i in 0:1){
    for(j in 0:1){
      for(g in 1:G){
        p <- p + phi_hat[i + 1, j + 1, g] * eta_hat[i + 1, j + 1, g] * Kexi_hat[g]
      }
    }
  }
  for(i in 0:1){
    for(g in 1:G){
      P[1] <- P[1] + phi_hat[2, i + 1, g] * eta_hat[2, i + 1, g] * Kexi_hat[g]
      P[2] <- P[2] + phi_hat[i + 1, 2, g] * eta_hat[i + 1, 2, g] * Kexi_hat[g]
      P[3] <- P[3] + (1 - phi_hat[1, i + 1, g]) * eta_hat[1, i + 1, g] * Kexi_hat[g]
      P[4] <- P[4] + (1 - phi_hat[i + 1, 1, g]) * eta_hat[i + 1, 1, g] * Kexi_hat[g]
    }
  }
  Se_hat <- array(0, dim = c(2))
  Sp_hat <- array(0, dim = c(2))
  Se_hat[1] <- P[1] / p
  Se_hat[2] <- P[2] / p
  Sp_hat[1] <- P[3] / (1 - p)
  Sp_hat[2] <- P[4] / (1 - p)
  return <- list(Se_hat, Sp_hat)
}
