
#'  Correction Methods Under the MAR Assumption with Two Relative Ordinal-Scale Test with Covariates and Estimate their Smooth ROC curve under different covariates
#'
#' @param N (s, r, u), where s means number of subjects verified with the disease conditions, r means number of subjects verified without the disease conditions, u means number of subjects without being verified.
#' @param X covariates in subjects
#'
#' @return a, b, sA
#' @importFrom stats pnorm
#' @importFrom stats nlminb
#' @importFrom stats qnorm
#' @importFrom graphics curve
#' @export
#'

Correct_Bias_5 <- function(N, X){
  incr <- function(X){
    L <- length(X)
    flag <- 0
    for(i in 1:(L - 1)){
      for(j in (i + 1):L){
        if(X[j] <= X[i] | is.na(X[i]) | is.na(X[j])){
          flag <- 1

        }
      }
    }
    return <- flag
  }

  ##theta为参数，各项含义为(p1, a, b, c1, ... c(K - 1)), N为数据，含义为(z10, ...zK0, z11, ...zK1, u1, ...uK)
  ML <- function(theta, N){
    p <- theta[1]
    a <- theta[2]
    b <- theta[3]
    L <- length(theta)
    c <- theta[4:L]
    K <- L - 2
    if(b <= 0 | p <= 0 | p >= 1 | is.na(a) | is.na(b) | is.na(p) | incr(c)){
      return <- 1e7
    }
    else{
      pi0 <- array(0, dim = c(K))
      pi1 <- array(0, dim = c(K))

      pi0[1] <- pnorm(c[1])
      pi0[K] <- 1 - pnorm(c[K - 1])
      pi1[1] <- pnorm(b * c[1] - a)
      pi1[K] <- 1 - pnorm(b * c[K - 1] - a)
      for(i in 2:(K - 1)){
        pi0[i] <- pnorm(c[i]) - pnorm(c[i - 1])
        pi1[i] <- pnorm(b * c[i] - a) - pnorm(b * c[i - 1] - a)
      }


      Q <- array(0, dim = c(3 * K))
      for(i in 1:K){
        Q[K + i] <- log((1 - p) * pi0[i])
        Q[i] <- log(p * pi1[i])
        Q[2 * K + i] <- log(p * pi1[i] + (1 - p) * pi0[i])

      }


      return <- -sum(Q * N, na.rm = TRUE)
    }
  }
  G <- ncol(X)
  K <- length(N) %/% (3 * G)
  if(3 * K * G < length(N)){
    print("error")
    return
  }
  theta0 <- array(0, dim = c(K + 2))
  theta0[1] <- 0.5
  theta0[2] <- 1
  theta0[3] <- 1

  theta0[4:(K + 2)] <- seq(from = -(K - 1), to = (K - 2), by = 2)

  sA <- array(0, dim = c(G))
  theta <- array(0, dim = c(K + 2, G))
  for(g in 1:G){
    orse <- nlminb(theta0, ML, N = N[, g])
    theta[, g] <- orse$par
    sA[g] <- pnorm(theta[2, g] / (sqrt(1 + theta[3, g]^2)))
    a <- theta[2, g]
    b <- theta[3, g]
    x <- 0
    curve(pnorm(b * qnorm(x) + a), 0, 1, n = 1000, xname = "x", xlab = "FPR", ylab = "TPR")
  }
  return <- list(a, b, sA)
}

